/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.any.FloatAnyAggregator;
import org.apache.druid.query.aggregation.any.FloatAnyBufferAggregator;
import org.apache.druid.query.aggregation.any.FloatAnyVectorAggregator;
import org.apache.druid.query.aggregation.any.NumericNilVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class FloatAnyAggregatorFactory
extends AggregatorFactory {
    private static final Comparator<Float> VALUE_COMPARATOR = Comparator.nullsFirst(Float::compare);
    private static final Aggregator NIL_AGGREGATOR = new FloatAnyAggregator(NilColumnValueSelector.instance()){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new FloatAnyBufferAggregator(NilColumnValueSelector.instance()){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    private final String fieldName;
    private final String name;

    @JsonCreator
    public FloatAnyAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new FloatAnyAggregator(valueSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new FloatAnyBufferAggregator(valueSelector);
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        if (capabilities == null || capabilities.isNumeric()) {
            return new FloatAnyVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
        }
        return NumericNilVectorAggregator.floatNilVectorAggregator();
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        return lhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("FloatAnyAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatAnyAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatAnyAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Float.valueOf(Float.parseFloat((String)object));
        }
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(68).appendString(this.fieldName).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return ColumnType.FLOAT;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.FLOAT;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 5;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new FloatAnyAggregatorFactory(newName, this.getFieldName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatAnyAggregatorFactory that = (FloatAnyAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name);
    }

    public String toString() {
        return "FloatAnyAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

