/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;

public class DoubleFirstAggregatorFactory
extends AggregatorFactory {
    private static final Aggregator NIL_AGGREGATOR = new DoubleFirstAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new DoubleFirstBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    public static final Comparator<SerializablePair<Long, Double>> VALUE_COMPARATOR = SerializablePair.createNullHandlingComparator(Double::compare, true);
    private final String fieldName;
    private final String timeColumn;
    private final String name;
    private final boolean storeDoubleAsFloat;

    @JsonCreator
    public DoubleFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
        this.storeDoubleAsFloat = ColumnHolder.storeDoubleAsFloat();
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new DoubleFirstAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new DoubleFirstBufferAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime <= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("DoubleFirstAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleFirstAggregatorFactory(this.name, this.name, this.timeColumn){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleFirstAggregatorFactory.this.name);
                return new DoubleFirstAggregator(null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        if ((Long)pair.lhs < this.firstTime) {
                            this.firstTime = (Long)pair.lhs;
                            if (pair.rhs != null) {
                                this.firstValue = (Double)pair.rhs;
                                this.rhsNull = false;
                            } else {
                                this.rhsNull = true;
                            }
                        }
                    }
                };
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleFirstAggregatorFactory.this.name);
                return new DoubleFirstBufferAggregator(null, null){

                    @Override
                    public void putValue(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        buf.putDouble(position, (Double)pair.rhs);
                    }

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        long firstTime = buf.getLong(position);
                        if ((Long)pair.lhs < firstTime) {
                            if (pair.rhs != null) {
                                this.updateTimeWithValue(buf, position, (Long)pair.lhs);
                            } else {
                                this.updateTimeWithNull(buf, position, (Long)pair.lhs);
                            }
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                };
            }
        };
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoubleFirstAggregatorFactory(this.fieldName, this.fieldName, this.timeColumn));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePair<Long, Object>(((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePair<Long, Double>(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).doubleValue());
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Double)((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(20).appendString(this.fieldName).appendString(this.timeColumn).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return this.storeDoubleAsFloat ? ColumnType.FLOAT : ColumnType.DOUBLE;
    }

    @Override
    public ColumnType getResultType() {
        return this.storeDoubleAsFloat ? ColumnType.FLOAT : ColumnType.DOUBLE;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 17;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new DoubleFirstAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleFirstAggregatorFactory that = (DoubleFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.timeColumn.equals(that.timeColumn) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.timeColumn);
    }

    public String toString() {
        return "DoubleFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", timeColumn='" + this.timeColumn + '\'' + '}';
    }
}

