/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class StringFirstLastUtils {
    private static final int NULL_VALUE = -1;

    public static boolean selectorNeedsFoldCheck(BaseObjectColumnValueSelector<?> valueSelector, @Nullable ColumnCapabilities valueSelectorCapabilities) {
        if (valueSelectorCapabilities != null && !valueSelectorCapabilities.is(ValueType.COMPLEX)) {
            return false;
        }
        if (valueSelector instanceof NilColumnValueSelector) {
            return false;
        }
        Class<SerializablePairLongString> clazz = valueSelector.classOfObject();
        return clazz.isAssignableFrom(SerializablePairLongString.class) || SerializablePairLongString.class.isAssignableFrom(clazz);
    }

    public static boolean objectNeedsFoldCheck(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<SerializablePairLongString> clazz = obj.getClass();
        return clazz.isAssignableFrom(SerializablePairLongString.class) || SerializablePairLongString.class.isAssignableFrom(clazz);
    }

    public static SerializablePairLongString readPairFromVectorSelectorsAtIndex(BaseLongVectorValueSelector timeSelector, VectorObjectSelector valueSelector, int index) {
        String string;
        long time;
        Object object = valueSelector.getObjectVector()[index];
        if (object instanceof SerializablePairLongString) {
            SerializablePairLongString pair = (SerializablePairLongString)object;
            time = (Long)pair.lhs;
            string = (String)pair.rhs;
        } else if (object != null) {
            time = timeSelector.getLongVector()[index];
            string = DimensionHandlerUtils.convertObjectToString(object);
        } else {
            return null;
        }
        return new SerializablePairLongString(time, string);
    }

    @Nullable
    public static SerializablePairLongString readPairFromSelectors(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector<?> valueSelector) {
        String string;
        long time;
        Object object = valueSelector.getObject();
        if (object instanceof SerializablePairLongString) {
            SerializablePairLongString pair = (SerializablePairLongString)object;
            time = (Long)pair.lhs;
            string = (String)pair.rhs;
        } else if (object != null) {
            time = timeSelector.getLong();
            string = DimensionHandlerUtils.convertObjectToString(object);
        } else {
            return null;
        }
        return new SerializablePairLongString(time, string);
    }

    public static void writePair(ByteBuffer buf, int position, SerializablePairLongString pair, int maxStringBytes) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.putLong((Long)pair.lhs);
        if (pair.rhs != null) {
            mutationBuffer.position(position + 8 + 4);
            mutationBuffer.limit(position + 8 + 4 + maxStringBytes);
            int len = StringUtils.toUtf8WithLimit((String)pair.rhs, mutationBuffer);
            mutationBuffer.putInt(position + 8, len);
        } else {
            mutationBuffer.putInt(-1);
        }
    }

    public static SerializablePairLongString readPair(ByteBuffer buf, int position) {
        ByteBuffer copyBuffer = buf.duplicate();
        copyBuffer.position(position);
        Long timeValue = copyBuffer.getLong();
        int stringSizeBytes = copyBuffer.getInt();
        if (stringSizeBytes >= 0) {
            byte[] valueBytes = new byte[stringSizeBytes];
            copyBuffer.get(valueBytes, 0, stringSizeBytes);
            return new SerializablePairLongString(timeValue, StringUtils.fromUtf8(valueBytes));
        }
        return new SerializablePairLongString(timeValue, null);
    }
}

