/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.NamedFunction;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;

public class NestedDataExpressions {
    @Nullable
    static Object unwrap(ExprEval input) {
        return NestedDataExpressions.unwrap(input.value());
    }

    static Object unwrap(Object input) {
        if (input instanceof Object[]) {
            return Arrays.stream((Object[])input).map(NestedDataExpressions::unwrap).toArray();
        }
        return StructuredData.unwrap(input);
    }

    static List<NestedPathPart> getJsonPathPartsFromLiteral(NamedFunction fn, Expr arg) {
        if (!arg.isLiteral() || !(arg.getLiteralValue() instanceof String)) {
            throw fn.validationFailed("second argument [%s] must be a literal [%s] value", arg.stringify(), ExpressionType.STRING);
        }
        List<NestedPathPart> parts = NestedPathFinder.parseJsonPath((String)arg.getLiteralValue());
        return parts;
    }

    public static class JsonKeysExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_keys";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            List<NestedPathPart> parts = NestedDataExpressions.getJsonPathPartsFromLiteral(this, args.get(1));
            final class JsonKeysExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                final /* synthetic */ List val$parts;
                final /* synthetic */ JsonKeysExprMacro this$0;

                public JsonKeysExpr(List<Expr> args) {
                    this.this$0 = this$0;
                    this.val$parts = var3_3;
                    super(this$0.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    return ExprEval.ofType(ExpressionType.STRING_ARRAY, NestedPathFinder.findKeys(NestedDataExpressions.unwrap(input), this.val$parts));
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new JsonKeysExpr(this.this$0, newArgs, this.val$parts));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING_ARRAY;
                }
            }
            return new JsonKeysExpr(this, args, parts);
        }
    }

    public static class JsonPathsExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_paths";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            StructuredDataProcessor processor = new StructuredDataProcessor(){

                @Override
                public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
                    return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                }

                @Override
                @Nullable
                public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
                    ExprEval eval = ExprEval.bestEffortArray(array);
                    if (eval.type().isArray() && eval.type().getElementType().isPrimitive()) {
                        return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                    }
                    return null;
                }
            };
            final class JsonPathsExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                final /* synthetic */ StructuredDataProcessor val$processor;
                final /* synthetic */ JsonPathsExprMacro this$0;

                public JsonPathsExpr(List<Expr> args) {
                    this.this$0 = this$0;
                    this.val$processor = var3_3;
                    super(this$0.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    StructuredDataProcessor.ProcessResults info = this.val$processor.processFields(NestedDataExpressions.unwrap(input));
                    List transformed = info.getLiteralFields().stream().map(NestedPathFinder::toNormalizedJsonPath).collect(Collectors.toList());
                    return ExprEval.ofType(ExpressionType.STRING_ARRAY, transformed);
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new JsonPathsExpr(this.this$0, newArgs, this.val$processor));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING_ARRAY;
                }
            }
            return new JsonPathsExpr(this, args, processor);
        }
    }

    public static class JsonQueryExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_query";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            List<NestedPathPart> parts = NestedDataExpressions.getJsonPathPartsFromLiteral(this, args.get(1));
            final class JsonQueryExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                final /* synthetic */ List val$parts;
                final /* synthetic */ JsonQueryExprMacro this$0;

                public JsonQueryExpr(List<Expr> args) {
                    this.this$0 = this$0;
                    this.val$parts = var3_3;
                    super(this$0.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    return ExprEval.ofComplex(ExpressionType.NESTED_DATA, NestedPathFinder.find(NestedDataExpressions.unwrap(input), this.val$parts));
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new JsonQueryExpr(this.this$0, newArgs, this.val$parts));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new JsonQueryExpr(this, args, parts);
        }
    }

    public static class JsonValueExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_value";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            List<NestedPathPart> parts = NestedDataExpressions.getJsonPathPartsFromLiteral(this, args.get(1));
            if (args.size() == 3 && args.get(2).isLiteral()) {
                ExpressionType castTo = ExpressionType.fromString((String)args.get(2).getLiteralValue());
                if (castTo == null) {
                    throw this.validationFailed("invalid output type: [%s]", args.get(2).getLiteralValue());
                }
                final class JsonValueCastExpr
                extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                    final /* synthetic */ List val$parts;
                    final /* synthetic */ ExpressionType val$castTo;
                    final /* synthetic */ JsonValueExprMacro this$0;

                    public JsonValueCastExpr(List<Expr> args) {
                        this.this$0 = this$0;
                        this.val$parts = var3_3;
                        this.val$castTo = var4_4;
                        super(this$0.name(), args);
                    }

                    @Override
                    public ExprEval eval(Expr.ObjectBinding bindings) {
                        ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                        return ExprEval.bestEffortOf(NestedPathFinder.findLiteral(NestedDataExpressions.unwrap(input), this.val$parts)).castTo(this.val$castTo);
                    }

                    @Override
                    public Expr visit(Expr.Shuttle shuttle) {
                        List newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                        return shuttle.visit(new JsonValueCastExpr(this.this$0, newArgs, this.val$parts, this.val$castTo));
                    }

                    @Override
                    @Nullable
                    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                        return this.val$castTo;
                    }
                }
                return new JsonValueCastExpr(this, args, parts, castTo);
            }
            final class JsonValueExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                final /* synthetic */ List val$parts;
                final /* synthetic */ JsonValueExprMacro this$0;

                public JsonValueExpr(List<Expr> args) {
                    this.this$0 = this$0;
                    this.val$parts = var3_3;
                    super(this$0.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    return ExprEval.bestEffortOf(NestedPathFinder.findLiteral(NestedDataExpressions.unwrap(input), this.val$parts));
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new JsonValueExpr(this.this$0, newArgs, this.val$parts));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return null;
                }
            }
            return new JsonValueExpr(this, args, parts);
        }
    }

    public static class TryParseJsonExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "try_parse_json";
        private final ObjectMapper jsonMapper;

        @Inject
        public TryParseJsonExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ParseJsonExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ParseJsonExpr(List<Expr> args) {
                    super(TryParseJsonExprMacro.this.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval arg = ((Expr)this.args.get(0)).eval(bindings);
                    if (arg.type().is(ExprType.STRING) && arg.value() != null) {
                        try {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, TryParseJsonExprMacro.this.jsonMapper.readValue(arg.asString(), Object.class));
                        }
                        catch (JsonProcessingException e) {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                        }
                    }
                    return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new ParseJsonExpr(newArgs));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new ParseJsonExpr(args);
        }
    }

    public static class ParseJsonExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "parse_json";
        private final ObjectMapper jsonMapper;

        @Inject
        public ParseJsonExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ParseJsonExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ParseJsonExpr(List<Expr> args) {
                    super(ParseJsonExprMacro.this.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval arg = ((Expr)this.args.get(0)).eval(bindings);
                    if (arg.value() == null) {
                        return ExprEval.ofComplex(ExpressionType.NESTED_DATA, null);
                    }
                    if (arg.type().is(ExprType.STRING)) {
                        try {
                            return ExprEval.ofComplex(ExpressionType.NESTED_DATA, ParseJsonExprMacro.this.jsonMapper.readValue(arg.asString(), Object.class));
                        }
                        catch (JsonProcessingException e) {
                            throw ParseJsonExprMacro.this.processingFailed(e, "bad string input [%s]", arg.asString());
                        }
                    }
                    throw ParseJsonExprMacro.this.validationFailed("invalid input expected %s but got %s instead", ExpressionType.STRING, arg.type());
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new ParseJsonExpr(newArgs));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new ParseJsonExpr(args);
        }
    }

    public static class ToJsonStringExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "to_json_string";
        private final ObjectMapper jsonMapper;

        @Inject
        public ToJsonStringExprMacro(@Json ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            final class ToJsonStringExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public ToJsonStringExpr(List<Expr> args) {
                    super(ToJsonStringExprMacro.this.name(), args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    try {
                        Object unwrapped = NestedDataExpressions.unwrap(input);
                        String stringify = unwrapped == null ? null : ToJsonStringExprMacro.this.jsonMapper.writeValueAsString(unwrapped);
                        return ExprEval.ofType(ExpressionType.STRING, stringify);
                    }
                    catch (JsonProcessingException e) {
                        throw ToJsonStringExprMacro.this.processingFailed(e, "unable to stringify [%s] to JSON", input.value());
                    }
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new ToJsonStringExpr(newArgs));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.STRING;
                }
            }
            return new ToJsonStringExpr(args);
        }
    }

    public static class JsonObjectExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "json_object";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            if (args.size() % 2 != 0) {
                throw this.validationFailed("must have an even number of arguments", new Object[0]);
            }
            class StructExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public StructExpr(List<Expr> args) {
                    super(JsonObjectExprMacro.NAME, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    HashMap<String, Object> theMap = new HashMap<String, Object>();
                    for (int i = 0; i < this.args.size(); i += 2) {
                        ExprEval field = ((Expr)this.args.get(i)).eval(bindings);
                        ExprEval value = ((Expr)this.args.get(i + 1)).eval(bindings);
                        if (!field.type().is(ExprType.STRING)) {
                            throw JsonObjectExprMacro.this.validationFailed("field name must be a STRING", new Object[0]);
                        }
                        theMap.put(field.asString(), NestedDataExpressions.unwrap(value));
                    }
                    return ExprEval.ofComplex(ExpressionType.NESTED_DATA, theMap);
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                    return shuttle.visit(new StructExpr(newArgs));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.NESTED_DATA;
                }
            }
            return new StructExpr(args);
        }
    }
}

