/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

@SubclassesMustOverrideEqualsAndHashCode
public interface Filter {
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector var1);

    public ValueMatcher makeMatcher(ColumnSelectorFactory var1);

    default public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        throw new UOE("Filter[%s] cannot vectorize", this.getClass().getName());
    }

    default public double estimateSelectivity(ColumnIndexSelector indexSelector) {
        return this.getBitmapColumnIndex(indexSelector).estimateSelectivity(indexSelector.getNumRows());
    }

    public boolean supportsSelectivityEstimation(ColumnSelector var1, ColumnIndexSelector var2);

    default public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return false;
    }

    public Set<String> getRequiredColumns();

    default public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    default public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        throw new UnsupportedOperationException("Required column rewrite is not supported by this filter.");
    }
}

