/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.groupby.epinephelinae.column.ArrayNumericGroupByColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ValueType;

public class ArrayLongGroupByColumnSelectorStrategy
extends ArrayNumericGroupByColumnSelectorStrategy<Long> {
    public ArrayLongGroupByColumnSelectorStrategy() {
        super(8);
    }

    @VisibleForTesting
    ArrayLongGroupByColumnSelectorStrategy(List<List<Long>> dictionary, Object2IntOpenHashMap<List<Long>> reverseDictionary) {
        super(dictionary, reverseDictionary, 8);
    }

    @Override
    protected int computeDictionaryId(ColumnValueSelector selector) {
        Object object = selector.getObject();
        if (object == null) {
            return -1;
        }
        if (object instanceof Long) {
            return this.addToIndexedDictionary(ImmutableList.of((Object)((Long)object)));
        }
        if (object instanceof List) {
            return this.addToIndexedDictionary((List)object);
        }
        if (object instanceof Long[]) {
            return this.addToIndexedDictionary(Arrays.asList((Long[])object));
        }
        if (object instanceof Object[]) {
            return this.addToIndexedDictionary(Arrays.stream((Object[])object).map(a -> (Long)a).collect(Collectors.toList()));
        }
        throw new ISE("Found unexpected object type [%s] in %s array.", object.getClass().getName(), ValueType.LONG);
    }
}

