/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.resource;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.logger.Logger;

public class GroupByQueryResource
implements Closeable {
    private static final Logger log = new Logger(GroupByQueryResource.class);
    private final List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders;
    private final Deque<ByteBuffer> mergeBuffers;

    public GroupByQueryResource() {
        this.mergeBufferHolders = null;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>();
    }

    public GroupByQueryResource(List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders) {
        this.mergeBufferHolders = mergeBufferHolders;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>(mergeBufferHolders.size());
        mergeBufferHolders.forEach(holder -> this.mergeBuffers.add((ByteBuffer)holder.get()));
    }

    public ResourceHolder<ByteBuffer> getMergeBuffer() {
        final ByteBuffer buffer = this.mergeBuffers.pop();
        return new ResourceHolder<ByteBuffer>(){

            @Override
            public ByteBuffer get() {
                return buffer;
            }

            @Override
            public void close() {
                GroupByQueryResource.this.mergeBuffers.add(buffer);
            }
        };
    }

    @Override
    public void close() {
        if (this.mergeBufferHolders != null) {
            if (this.mergeBuffers.size() != this.mergeBufferHolders.size()) {
                log.warn("%d resources are not returned yet", this.mergeBufferHolders.size() - this.mergeBuffers.size());
            }
            this.mergeBufferHolders.forEach(ReferenceCountingResourceHolder::close);
        }
    }
}

