/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.DefaultClusteredGroupPartitioner;

public class NaivePartitioningOperator
implements Operator {
    private final List<String> partitionColumns;
    private final Operator child;
    private Iterator<RowsAndColumns> partitionsIter;

    public NaivePartitioningOperator(List<String> partitionColumns, Operator child) {
        this.partitionColumns = partitionColumns;
        this.child = child;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, final Operator.Receiver receiver) {
        return this.child.goOrContinue(continuation, new Operator.Receiver(){

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                ClusteredGroupPartitioner groupPartitioner = rac.as(ClusteredGroupPartitioner.class);
                if (groupPartitioner == null) {
                    groupPartitioner = new DefaultClusteredGroupPartitioner(rac);
                }
                NaivePartitioningOperator.this.partitionsIter = groupPartitioner.partitionOnBoundaries(NaivePartitioningOperator.this.partitionColumns).iterator();
                Operator.Signal keepItGoing = Operator.Signal.GO;
                while (keepItGoing == Operator.Signal.GO && NaivePartitioningOperator.this.partitionsIter.hasNext()) {
                    keepItGoing = receiver.push((RowsAndColumns)NaivePartitioningOperator.this.partitionsIter.next());
                }
                return keepItGoing;
            }

            @Override
            public void completed() {
                receiver.completed();
            }
        });
    }
}

