/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.operator.NaivePartitioningOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;

public class NaivePartitioningOperatorFactory
implements OperatorFactory {
    private final List<String> partitionColumns;

    @JsonCreator
    public NaivePartitioningOperatorFactory(@JsonProperty(value="partitionColumns") List<String> partitionColumns) {
        this.partitionColumns = partitionColumns == null ? new ArrayList() : partitionColumns;
    }

    @JsonProperty(value="partitionColumns")
    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    @Override
    public Operator wrap(Operator op) {
        return new NaivePartitioningOperator(this.partitionColumns, op);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        if (other instanceof NaivePartitioningOperatorFactory) {
            return this.partitionColumns.equals(((NaivePartitioningOperatorFactory)other).getPartitionColumns());
        }
        return false;
    }

    public String toString() {
        return "NaivePartitioningOperatorFactory{partitionColumns=" + this.partitionColumns + '}';
    }
}

