/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public class OperatorSequence
implements Sequence<RowsAndColumns> {
    private final Supplier<Operator> opSupplier;

    public OperatorSequence(Supplier<Operator> opSupplier) {
        this.opSupplier = opSupplier;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, final Accumulator<OutType, RowsAndColumns> accumulator) {
        MyReceiver<OutType> receiver = new MyReceiver<OutType>(initValue, new YieldingAccumulator<OutType, RowsAndColumns>(){

            @Override
            public OutType accumulate(OutType accumulated, RowsAndColumns in) {
                return accumulator.accumulate(accumulated, in);
            }
        });
        Operator.go(this.opSupplier.get(), receiver);
        return receiver.getRetVal();
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, RowsAndColumns> accumulator) {
        MyReceiver<OutType> receiver;
        final Operator op = this.opSupplier.get();
        final Closeable finalContinuation = op.goOrContinue(null, receiver = new MyReceiver<OutType>(initValue, accumulator));
        if (finalContinuation == null && !accumulator.yielded()) {
            return Yielders.done(receiver.getRetVal(), null);
        }
        return new Yielder<OutType>(){
            private Closeable continuation;
            {
                this.continuation = finalContinuation;
            }

            @Override
            public OutType get() {
                return receiver.getRetVal();
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                if (this.continuation == null) {
                    return Yielders.done(null, null);
                }
                receiver.setRetVal(initValue);
                this.continuation = op.goOrContinue(this.continuation, receiver);
                return this;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                if (this.continuation != null) {
                    this.continuation.close();
                }
            }
        };
    }

    private static class MyReceiver<OutType>
    implements Operator.Receiver {
        private final YieldingAccumulator<OutType, RowsAndColumns> accumulator;
        private OutType retVal;

        public MyReceiver(OutType initValue, YieldingAccumulator<OutType, RowsAndColumns> accumulator) {
            this.accumulator = accumulator;
            this.retVal = initValue;
        }

        public void setRetVal(OutType retVal) {
            this.retVal = retVal;
        }

        public OutType getRetVal() {
            return this.retVal;
        }

        @Override
        public Operator.Signal push(RowsAndColumns rac) {
            this.retVal = this.accumulator.accumulate(this.retVal, rac);
            return this.accumulator.yielded() ? Operator.Signal.PAUSE : Operator.Signal.GO;
        }

        @Override
        public void completed() {
        }
    }
}

