/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public class SequenceOperator
implements Operator {
    private static final Logger log = new Logger(SequenceOperator.class);
    private final Sequence<RowsAndColumns> child;

    public SequenceOperator(Sequence<RowsAndColumns> child) {
        this.child = child;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, final Operator.Receiver receiver) {
        Operator.Signal theSignal;
        Yielder<Operator.Signal> yielder = null;
        if (continuation == null) {
            yielder = this.child.toYielder(Operator.Signal.GO, new YieldingAccumulator<Operator.Signal, RowsAndColumns>(){

                @Override
                public Operator.Signal accumulate(Operator.Signal accumulated, RowsAndColumns in) {
                    Operator.Signal pushSignal = receiver.push(in);
                    switch (pushSignal) {
                        case PAUSE: {
                            this.yield();
                            return Operator.Signal.PAUSE;
                        }
                        case GO: {
                            return Operator.Signal.GO;
                        }
                        case STOP: {
                            this.yield();
                            return Operator.Signal.STOP;
                        }
                    }
                    throw new ISE("How can this be happening? signal[%s]", new Object[]{pushSignal});
                }
            });
            theSignal = yielder.get();
        } else {
            try {
                Yielder castedYielder = (Yielder)continuation;
                if (castedYielder.isDone()) {
                    throw new ISE("The yielder is done!  The previous go call should've resulted in completion instead of continuation", new Object[0]);
                }
                yielder = castedYielder.next(Operator.Signal.GO);
                theSignal = yielder.get();
            }
            catch (ClassCastException e) {
                try {
                    if (yielder == null) {
                        continuation.close();
                    } else {
                        yielder.close();
                    }
                }
                catch (IOException ex) {
                    e.addSuppressed(new ISE("Unable to close continuation[%s] of type[%s]", continuation, continuation.getClass()));
                }
                throw e;
            }
        }
        switch (theSignal) {
            case GO: 
            case STOP: {
                try {
                    receiver.completed();
                }
                catch (RuntimeException e) {
                    try {
                        yielder.close();
                    }
                    catch (IOException ioException) {
                        e.addSuppressed(ioException);
                        throw e;
                    }
                }
                try {
                    yielder.close();
                }
                catch (IOException e) {
                    log.warn(e, "Exception thrown when closing yielder.  Logging and ignoring because results should be fine.", new Object[0]);
                }
                return null;
            }
            case PAUSE: {
                return yielder;
            }
        }
        throw new ISE("How can this happen!? signal[%s]", new Object[]{theSignal});
    }
}

