/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQuery
extends BaseQuery<RowsAndColumns> {
    private final RowSignature rowSignature;
    private final List<OperatorFactory> operators;

    @JsonCreator
    public WindowOperatorQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="outputSignature") RowSignature rowSignature, @JsonProperty(value="operatorDefinition") List<OperatorFactory> operators) {
        super(dataSource, new LegacySegmentSpec(Intervals.ETERNITY), false, context);
        this.rowSignature = rowSignature;
        this.operators = operators;
        if (!(dataSource instanceof QueryDataSource) && !(dataSource instanceof InlineDataSource)) {
            throw new IAE("WindowOperatorQuery must run on top of a query or inline data source, got [%s]", dataSource);
        }
    }

    @JsonProperty(value="operatorDefinition")
    public List<OperatorFactory> getOperators() {
        return this.operators;
    }

    @JsonProperty(value="outputSignature")
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    @Nullable
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "windowOperator";
    }

    @Override
    public Query<RowsAndColumns> withOverriddenContext(Map<String, Object> contextOverride) {
        return new WindowOperatorQuery(this.getDataSource(), WindowOperatorQuery.computeOverriddenContext(this.getContext(), contextOverride), this.rowSignature, this.operators);
    }

    @Override
    public Query<RowsAndColumns> withQuerySegmentSpec(QuerySegmentSpec spec) {
        throw new UOE("Cannot override querySegmentSpec on window operator query. [%s]", spec);
    }

    @Override
    public Query<RowsAndColumns> withDataSource(DataSource dataSource) {
        return new WindowOperatorQuery(dataSource, this.getContext(), this.rowSignature, this.operators);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowOperatorQuery that = (WindowOperatorQuery)o;
        return Objects.equals(this.rowSignature, that.rowSignature) && Objects.equals(this.operators, that.operators);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowSignature, this.operators);
    }

    public String toString() {
        return "WindowOperatorQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", context=" + this.getContext() + ", rowSignature=" + this.rowSignature + ", operators=" + this.operators + '}';
    }
}

