/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowProcessorOperator;
import org.apache.druid.query.operator.window.Processor;

public class WindowOperatorFactory
implements OperatorFactory {
    private Processor processor;

    @JsonCreator
    public WindowOperatorFactory(@JsonProperty(value="processor") Processor processor) {
        Preconditions.checkNotNull((Object)processor, (Object)"processor cannot be null");
        this.processor = processor;
    }

    @JsonProperty(value="processor")
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Operator wrap(Operator op) {
        return new WindowProcessorOperator(this.processor, op);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        if (other instanceof WindowOperatorFactory) {
            return this.processor.validateEquivalent(((WindowOperatorFactory)other).getProcessor());
        }
        return false;
    }

    public String toString() {
        return "WindowOperatorFactory{processor=" + this.processor + '}';
    }
}

