/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.ObjectColumnAccessorBase;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class ObjectArrayColumn
implements Column {
    private final Object[] objects;
    private final ColumnType resultType;
    private final Comparator<Object> comparator;

    public ObjectArrayColumn(Object[] objects, ColumnType resultType) {
        this(objects, resultType, Comparator.nullsFirst(resultType.getStrategy()));
    }

    public ObjectArrayColumn(Object[] objects, ColumnType resultType, Comparator<Object> comparator) {
        this.objects = objects;
        this.resultType = resultType;
        this.comparator = comparator;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new MyColumnAccessor();
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        if (VectorCopier.class.equals(clazz)) {
            return (T)((VectorCopier)(into, intoStart) -> System.arraycopy(this.objects, 0, into, intoStart, this.objects.length));
        }
        if (ColumnValueSwapper.class.equals(clazz)) {
            return (T)((ColumnValueSwapper)(lhs, rhs) -> {
                Object tmp = this.objects[lhs];
                this.objects[lhs] = this.objects[rhs];
                this.objects[rhs] = tmp;
            });
        }
        return null;
    }

    private class MyColumnAccessor
    extends ObjectColumnAccessorBase
    implements BinarySearchableAccessor {
        private MyColumnAccessor() {
        }

        @Override
        protected Object getVal(int rowNum) {
            return ObjectArrayColumn.this.objects[rowNum];
        }

        @Override
        protected Comparator<Object> getComparator() {
            return ObjectArrayColumn.this.comparator;
        }

        @Override
        public ColumnType getType() {
            return ObjectArrayColumn.this.resultType;
        }

        @Override
        public int numRows() {
            return ObjectArrayColumn.this.objects.length;
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return this.findComplex(startIndex, endIndex, null);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return this.findComplex(startIndex, endIndex, Float.valueOf(val));
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            return this.findComplex(startIndex, endIndex, val);
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            if (ObjectArrayColumn.this.comparator.compare(ObjectArrayColumn.this.objects[startIndex], val) == 0) {
                int end;
                for (end = startIndex + 1; end < endIndex && ObjectArrayColumn.this.comparator.compare(ObjectArrayColumn.this.objects[end], val) == 0; ++end) {
                }
                return FindResult.found(startIndex, end);
            }
            int i = Arrays.binarySearch(ObjectArrayColumn.this.objects, startIndex, endIndex, val, ObjectArrayColumn.this.comparator);
            if (i > 0) {
                int foundStart = i;
                int foundEnd = i + 1;
                while (foundStart - 1 >= startIndex && ObjectArrayColumn.this.comparator.compare(ObjectArrayColumn.this.objects[foundStart - 1], val) == 0) {
                    --foundStart;
                }
                while (foundEnd < endIndex && ObjectArrayColumn.this.comparator.compare(ObjectArrayColumn.this.objects[foundEnd], val) == 0) {
                    ++foundEnd;
                }
                return FindResult.found(foundStart, foundEnd);
            }
            return FindResult.notFound(-(i + 1));
        }
    }
}

