/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;

public abstract class ObjectColumnAccessorBase
implements ColumnAccessor {
    @Override
    public boolean isNull(int rowNum) {
        return this.getVal(rowNum) == null;
    }

    @Override
    @Nullable
    public Object getObject(int rowNum) {
        return this.getVal(rowNum);
    }

    @Override
    public double getDouble(int rowNum) {
        Object val = this.getVal(rowNum);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            try {
                return Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public float getFloat(int rowNum) {
        Object val = this.getVal(rowNum);
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        if (val instanceof String) {
            try {
                return Float.parseFloat((String)val);
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public long getLong(int rowNum) {
        Object val = this.getVal(rowNum);
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            try {
                return Long.parseLong((String)val);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    @Override
    public int getInt(int rowNum) {
        Object val = this.getVal(rowNum);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int compareRows(int lhsRowNum, int rhsRowNum) {
        return this.getComparator().compare(this.getVal(lhsRowNum), this.getVal(rhsRowNum));
    }

    protected abstract Object getVal(int var1);

    protected abstract Comparator<Object> getComparator();
}

