/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class DefaultColumnSelectorFactoryMaker
implements ColumnSelectorFactoryMaker {
    private final RowsAndColumns rac;

    public DefaultColumnSelectorFactoryMaker(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public ColumnSelectorFactory make(AtomicInteger rowIdProvider) {
        return new ColumnAccessorBasedColumnSelectorFactory(rowIdProvider, this.rac);
    }

    public static class ColumnAccessorBasedColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final Map<String, ColumnAccessor> accessorCache = new HashMap<String, ColumnAccessor>();
        private final AtomicInteger cellIdSupplier;
        private final RowsAndColumns rac;

        public ColumnAccessorBasedColumnSelectorFactory(AtomicInteger cellIdSupplier, RowsAndColumns rac) {
            this.cellIdSupplier = cellIdSupplier;
            this.rac = rac;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.withColumnAccessor(dimensionSpec.getDimension(), columnAccessor -> {
                if (columnAccessor == null) {
                    return DimensionSelector.constant(null);
                }
                return new BaseSingleValueDimensionSelector((ColumnAccessor)columnAccessor){
                    final /* synthetic */ ColumnAccessor val$columnAccessor;
                    {
                        this.val$columnAccessor = columnAccessor;
                    }

                    @Override
                    @Nullable
                    protected String getValue() {
                        return String.valueOf(this.val$columnAccessor.getObject(cellIdSupplier.get()));
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            });
        }

        @Override
        public ColumnValueSelector makeColumnValueSelector(@Nonnull String columnName) {
            return this.withColumnAccessor(columnName, columnAccessor -> {
                if (columnAccessor == null) {
                    return DimensionSelector.constant(null);
                }
                return new ColumnValueSelector((ColumnAccessor)columnAccessor){
                    private final AtomicReference myClazz = new AtomicReference<Object>(null);
                    final /* synthetic */ ColumnAccessor val$columnAccessor;
                    {
                        this.val$columnAccessor = columnAccessor;
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return this.val$columnAccessor.getObject(cellIdSupplier.get());
                    }

                    @Override
                    public Class classOfObject() {
                        Class retVal = (Class)this.myClazz.get();
                        if (retVal == null) {
                            retVal = this.findClazz();
                            this.myClazz.set(retVal);
                        }
                        return retVal;
                    }

                    private Class findClazz() {
                        ColumnType type = this.val$columnAccessor.getType();
                        switch ((ValueType)type.getType()) {
                            case LONG: {
                                return Long.TYPE;
                            }
                            case DOUBLE: {
                                return Double.TYPE;
                            }
                            case FLOAT: {
                                return Float.TYPE;
                            }
                            case STRING: {
                                return String.class;
                            }
                            case ARRAY: {
                                return List.class;
                            }
                            case COMPLEX: {
                                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(type.getComplexTypeName());
                                if (serdeForType != null && serdeForType.getObjectStrategy() != null) {
                                    return serdeForType.getObjectStrategy().getClazz();
                                }
                                for (int i = 0; i < this.val$columnAccessor.numRows(); ++i) {
                                    Object obj = this.val$columnAccessor.getObject(i);
                                    if (obj == null) continue;
                                    return obj.getClass();
                                }
                                return Object.class;
                            }
                        }
                        throw new ISE("Unknown type[%s]", type.getType());
                    }

                    @Override
                    public boolean isNull() {
                        return this.val$columnAccessor.isNull(cellIdSupplier.get());
                    }

                    @Override
                    public long getLong() {
                        return this.val$columnAccessor.getLong(cellIdSupplier.get());
                    }

                    @Override
                    public float getFloat() {
                        return this.val$columnAccessor.getFloat(cellIdSupplier.get());
                    }

                    @Override
                    public double getDouble() {
                        return this.val$columnAccessor.getDouble(cellIdSupplier.get());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            });
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return this.withColumnAccessor(column, columnAccessor -> new ColumnCapabilitiesImpl().setType(columnAccessor.getType()).setDictionaryEncoded(false).setHasBitmapIndexes(false));
        }

        private <T> T withColumnAccessor(String column, Function<ColumnAccessor, T> fn) {
            ColumnAccessor retVal = this.accessorCache.get(column);
            if (retVal == null) {
                Column racColumn = this.rac.findColumn(column);
                retVal = racColumn == null ? null : racColumn.toAccessor();
                this.accessorCache.put(column, retVal);
            }
            return fn.apply(retVal);
        }
    }
}

