/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DictionaryMergingIterator;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.IntIteratorUtils;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.ColumnarIntsSerializer;
import org.apache.druid.segment.data.ColumnarMultiIntsSerializer;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarMultiIntsSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class DictionaryEncodedColumnMerger<T extends Comparable<T>>
implements DimensionMergerV9 {
    private static final Logger log = new Logger(DictionaryEncodedColumnMerger.class);
    protected final String dimensionName;
    protected final ProgressIndicator progress;
    protected final Closer closer;
    protected final IndexSpec indexSpec;
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final MutableBitmap nullRowsBitmap;
    protected final ColumnCapabilities capabilities;
    protected int dictionarySize;
    protected int rowCount = 0;
    protected int cardinality = 0;
    protected boolean hasNull = false;
    @Nullable
    protected GenericIndexedWriter<ImmutableBitmap> bitmapWriter;
    @Nullable
    protected ArrayList<IntBuffer> dimConversions;
    @Nullable
    protected List<IndexableAdapter> adapters;
    @Nullable
    protected DictionaryMergingIterator<T> dictionaryMergeIterator;
    @Nullable
    protected ColumnarIntsSerializer encodedValueSerializer;
    @Nullable
    protected DictionaryWriter<T> dictionaryWriter;
    @Nullable
    protected T firstDictionaryValue;

    public DictionaryEncodedColumnMerger(String dimensionName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        this.capabilities = capabilities;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.nullRowsBitmap = indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        this.progress = progress;
        this.closer = closer;
    }

    protected abstract Comparator<Pair<Integer, PeekingIterator<T>>> getDictionaryMergingComparator();

    protected abstract Indexed<T> getNullDimValue();

    protected abstract ObjectStrategy<T> getObjectStrategy();

    @Nullable
    protected abstract T coerceValue(T var1);

    @Override
    public void writeMergedValueDictionary(List<IndexableAdapter> adapters) throws IOException {
        boolean convertMissingValues;
        boolean dimHasValues = false;
        boolean dimAbsentFromSomeIndex = false;
        long dimStartTime = System.currentTimeMillis();
        this.adapters = adapters;
        this.dimConversions = Lists.newArrayListWithCapacity((int)adapters.size());
        for (int i = 0; i < adapters.size(); ++i) {
            this.dimConversions.add(null);
        }
        int numMergeIndex = 0;
        Indexed dimValueLookup = null;
        Indexed[] dimValueLookups = new Indexed[adapters.size() + 1];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed dimValues = this.closer.register(adapters.get(i).getDimValueLookup(this.dimensionName));
            if (dimValues != null && !this.allNull(dimValues)) {
                dimHasValues = true;
                this.hasNull = this.hasNull || dimValues.indexOf(null) >= 0;
                dimValueLookups[i] = dimValueLookup = dimValues;
                ++numMergeIndex;
                continue;
            }
            dimAbsentFromSomeIndex = true;
        }
        boolean bl = convertMissingValues = dimHasValues && dimAbsentFromSomeIndex;
        if (convertMissingValues && !this.hasNull) {
            this.hasNull = true;
            dimValueLookups[adapters.size()] = dimValueLookup = this.getNullDimValue();
            ++numMergeIndex;
        }
        String dictFilename = StringUtils.format("%s.dim_values", this.dimensionName);
        this.dictionaryWriter = this.makeDictionaryWriter(dictFilename);
        this.firstDictionaryValue = null;
        this.dictionarySize = 0;
        this.dictionaryWriter.open();
        this.cardinality = 0;
        if (numMergeIndex > 1) {
            this.dictionaryMergeIterator = new DictionaryMergingIterator<T>(dimValueLookups, this.getDictionaryMergingComparator(), true);
            this.writeDictionary(() -> this.dictionaryMergeIterator);
            for (int i = 0; i < adapters.size(); ++i) {
                if (dimValueLookups[i] == null || !this.dictionaryMergeIterator.needConversion(i)) continue;
                this.dimConversions.set(i, this.dictionaryMergeIterator.conversions[i]);
            }
            this.cardinality = this.dictionaryMergeIterator.getCardinality();
        } else if (numMergeIndex == 1) {
            this.writeDictionary(dimValueLookup);
            this.cardinality = dimValueLookup.size();
        }
        log.debug("Completed dim[%s] conversions with cardinality[%,d] in %,d millis.", this.dimensionName, this.cardinality, System.currentTimeMillis() - dimStartTime);
        this.setupEncodedValueWriter();
    }

    @Override
    public ColumnValueSelector convertSortedSegmentRowValuesToMergedRowValues(int segmentIndex, final ColumnValueSelector source) {
        final IntBuffer converter = this.dimConversions.get(segmentIndex);
        if (converter == null) {
            return source;
        }
        final DimensionSelector sourceDimensionSelector = (DimensionSelector)source;
        final IndexedInts convertedRow = new IndexedInts(){

            @Override
            public int size() {
                return sourceDimensionSelector.getRow().size();
            }

            @Override
            public int get(int index) {
                return converter.get(sourceDimensionSelector.getRow().get(index));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("source", source);
                inspector.visit("converter", converter);
            }
        };
        return new DimensionSelector(){

            @Override
            public IndexedInts getRow() {
                return convertedRow;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("convertedRow", convertedRow);
            }

            @Override
            public ValueMatcher makeValueMatcher(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getValueCardinality() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public Object getObject() {
                return sourceDimensionSelector.getObject();
            }

            @Override
            public Class classOfObject() {
                return sourceDimensionSelector.classOfObject();
            }
        };
    }

    @Override
    public void processMergedRow(ColumnValueSelector selector) throws IOException {
        IndexedInts row = DictionaryEncodedColumnMerger.getRow(selector);
        int rowSize = row.size();
        if (rowSize == 0) {
            this.nullRowsBitmap.add(this.rowCount);
        } else if (this.hasNull && DictionaryEncodedColumnMerger.isNullRow(row, rowSize)) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        if (this.encodedValueSerializer instanceof ColumnarMultiIntsSerializer) {
            ((ColumnarMultiIntsSerializer)this.encodedValueSerializer).addValues(row);
        } else {
            int value = row.size() == 0 ? 0 : row.get(0);
            ((SingleValueColumnarIntsSerializer)this.encodedValueSerializer).addValue(value);
        }
        ++this.rowCount;
    }

    @Override
    public void writeIndexes(@Nullable List<IntBuffer> segmentRowNumConversions) throws IOException {
        if (!this.capabilities.hasBitmapIndexes()) {
            return;
        }
        long dimStartTime = System.currentTimeMillis();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        String bmpFilename = StringUtils.format("%s.inverted", this.dimensionName);
        this.bitmapWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, bmpFilename, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapWriter.open();
        this.bitmapWriter.setObjectsNotSorted();
        BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
        ExtendedIndexesMerger extendedIndexesMerger = this.getExtendedIndexesMerger();
        if (extendedIndexesMerger != null) {
            extendedIndexesMerger.initialize();
        }
        IndexSeeker[] dictIdSeeker = this.toIndexSeekers(this.adapters, this.dimConversions, this.dimensionName);
        for (int dictId = 0; dictId < this.dictionarySize; ++dictId) {
            this.progress.progress();
            MutableBitmap mergedIndexes = this.mergeBitmaps(segmentRowNumConversions, bitmapFactory, dictIdSeeker, dictId);
            if (extendedIndexesMerger == null) continue;
            extendedIndexesMerger.mergeIndexes(dictId, mergedIndexes);
        }
        if (extendedIndexesMerger != null) {
            extendedIndexesMerger.write();
        }
        log.debug("Completed dim[%s] inverted with cardinality[%,d] in %,d millis.", this.dimensionName, this.dictionarySize, System.currentTimeMillis() - dimStartTime);
        if (this.dictionaryMergeIterator != null) {
            this.dictionaryMergeIterator.close();
        }
    }

    protected DictionaryWriter<T> makeDictionaryWriter(String fileName) {
        return new GenericIndexedWriter<T>(this.segmentWriteOutMedium, fileName, this.getObjectStrategy());
    }

    @Nullable
    protected ExtendedIndexesMerger getExtendedIndexesMerger() {
        return null;
    }

    protected void setupEncodedValueWriter() throws IOException {
        CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        String filenameBase = StringUtils.format("%s.forward_dim", this.dimensionName);
        this.encodedValueSerializer = this.capabilities.hasMultipleValues().isTrue() ? (compressionStrategy != CompressionStrategy.UNCOMPRESSED ? V3CompressedVSizeColumnarMultiIntsSerializer.create(this.dimensionName, this.segmentWriteOutMedium, filenameBase, this.cardinality, compressionStrategy) : new VSizeColumnarMultiIntsSerializer(this.dimensionName, this.segmentWriteOutMedium, this.cardinality)) : (compressionStrategy != CompressionStrategy.UNCOMPRESSED ? CompressedVSizeColumnarIntsSerializer.create(this.dimensionName, this.segmentWriteOutMedium, filenameBase, this.cardinality, compressionStrategy) : new VSizeColumnarIntsSerializer(this.segmentWriteOutMedium, this.cardinality));
        this.encodedValueSerializer.open();
    }

    protected void writeDictionary(Iterable<T> dictionaryValues) throws IOException {
        for (Comparable value : dictionaryValues) {
            this.dictionaryWriter.write(value);
            value = this.coerceValue(value);
            if (this.dictionarySize == 0) {
                this.firstDictionaryValue = value;
            }
            ++this.dictionarySize;
        }
    }

    protected MutableBitmap mergeBitmaps(@Nullable List<IntBuffer> segmentRowNumConversions, BitmapFactory bmpFactory, IndexSeeker[] dictIdSeeker, int dictId) throws IOException {
        ArrayList convertedInvertedIndexesToMerge = Lists.newArrayListWithCapacity((int)this.adapters.size());
        for (int j = 0; j < this.adapters.size(); ++j) {
            IntIterable values;
            int seekedDictId = dictIdSeeker[j].seek(dictId);
            if (seekedDictId == -1) continue;
            if (segmentRowNumConversions != null) {
                values = new ConvertingBitmapValues(this.adapters.get(j).getBitmapValues(this.dimensionName, seekedDictId), segmentRowNumConversions.get(j));
            } else {
                BitmapValues bitmapValues = this.adapters.get(j).getBitmapValues(this.dimensionName, seekedDictId);
                values = bitmapValues::iterator;
            }
            convertedInvertedIndexesToMerge.add(values);
        }
        MutableBitmap mergedIndexes = bmpFactory.makeEmptyMutableBitmap();
        ArrayList<IntIterator> convertedInvertedIndexesIterators = new ArrayList<IntIterator>(convertedInvertedIndexesToMerge.size());
        for (IntIterable convertedInvertedIndexes : convertedInvertedIndexesToMerge) {
            convertedInvertedIndexesIterators.add(convertedInvertedIndexes.iterator());
        }
        int prevRow = -1;
        IntIterator mergeIt = IntIteratorUtils.mergeAscending(convertedInvertedIndexesIterators);
        while (mergeIt.hasNext()) {
            int row = mergeIt.nextInt();
            if (row != prevRow && row != -1) {
                mergedIndexes.add(row);
            }
            prevRow = row;
        }
        if (dictId == 0 && this.firstDictionaryValue == null) {
            mergedIndexes.or(this.nullRowsBitmap);
        }
        this.bitmapWriter.write(bmpFactory.makeImmutableBitmap(mergedIndexes));
        return mergedIndexes;
    }

    @Override
    public boolean hasOnlyNulls() {
        return this.cardinality == 0;
    }

    protected IndexSeeker[] toIndexSeekers(List<IndexableAdapter> adapters, ArrayList<IntBuffer> dimConversions, String dimension) {
        IndexSeeker[] seekers = new IndexSeeker[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            IntBuffer dimConversion = dimConversions.get(i);
            if (dimConversion != null) {
                seekers[i] = new IndexSeekerWithConversion((IntBuffer)dimConversion.asReadOnlyBuffer().rewind());
                continue;
            }
            try (CloseableIndexed dimValueLookup = adapters.get(i).getDimValueLookup(dimension);){
                seekers[i] = new IndexSeekerWithoutConversion(dimValueLookup == null ? 0 : dimValueLookup.size());
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return seekers;
    }

    private boolean allNull(Indexed<T> dimValues) {
        int size = dimValues.size();
        for (int i = 0; i < size; ++i) {
            if (dimValues.get(i) == null) continue;
            return false;
        }
        return true;
    }

    private static IndexedInts getRow(ColumnValueSelector s) {
        if (s instanceof DimensionSelector) {
            return ((DimensionSelector)s).getRow();
        }
        if (s instanceof NilColumnValueSelector) {
            return IndexedInts.empty();
        }
        throw new ISE("ColumnValueSelector[%s], only DimensionSelector or NilColumnValueSelector is supported", s.getClass());
    }

    private static boolean isNullRow(IndexedInts row, int size) {
        for (int i = 0; i < size; ++i) {
            if (row.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    static interface ExtendedIndexesMerger {
        public void initialize() throws IOException;

        public void mergeIndexes(int var1, MutableBitmap var2) throws IOException;

        public void write() throws IOException;
    }

    public static class ConvertingBitmapValues
    implements IntIterable {
        private final BitmapValues baseValues;
        private final IntBuffer conversionBuffer;

        ConvertingBitmapValues(BitmapValues baseValues, IntBuffer conversionBuffer) {
            this.baseValues = baseValues;
            this.conversionBuffer = conversionBuffer;
        }

        @Nonnull
        public IntIterator iterator() {
            final IntIterator baseIterator = this.baseValues.iterator();
            return new IntIterator(){

                public boolean hasNext() {
                    return baseIterator.hasNext();
                }

                public int nextInt() {
                    return conversionBuffer.get(baseIterator.nextInt());
                }

                public int skip(int n) {
                    return IntIteratorUtils.skip(baseIterator, n);
                }
            };
        }
    }

    protected static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", dictId, this.lastVal);
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", this.currVal, this.currIndex, dictId);
            }
            return -1;
        }
    }

    protected static class IndexSeekerWithoutConversion
    implements IndexSeeker {
        private final int limit;

        public IndexSeekerWithoutConversion(int limit) {
            this.limit = limit;
        }

        @Override
        public int seek(int dictId) {
            return dictId < this.limit ? dictId : -1;
        }
    }

    protected static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

