/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.errorprone.annotations.MustBeClosed;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.joda.time.Interval;

public interface IndexableAdapter {
    public Interval getDataInterval();

    public int getNumRows();

    public List<String> getDimensionNames();

    public List<String> getMetricNames();

    @Nullable
    @MustBeClosed
    public <T extends Comparable<? super T>> CloseableIndexed<T> getDimValueLookup(String var1);

    @Nullable
    public NestedColumnMergable getNestedColumnMergeables(String var1);

    public TransformableRowIterator getRows();

    public BitmapValues getBitmapValues(String var1, int var2);

    public ColumnCapabilities getCapabilities(String var1);

    default public ColumnFormat getFormat(String column) {
        return new CapabilitiesBasedFormat(this.getCapabilities(column));
    }

    public Metadata getMetadata();

    public static class NestedColumnMergable
    implements Closeable {
        private final SortedValueDictionary valueDictionary;
        private final SortedMap<String, FieldTypeInfo.MutableTypeSet> fields;

        public NestedColumnMergable(SortedValueDictionary valueDictionary, SortedMap<String, FieldTypeInfo.MutableTypeSet> fields) {
            this.valueDictionary = valueDictionary;
            this.fields = fields;
        }

        @Nullable
        public SortedValueDictionary getValueDictionary() {
            return this.valueDictionary;
        }

        public void mergeFieldsInto(SortedMap<String, FieldTypeInfo.MutableTypeSet> mergeInto) {
            for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> entry : this.fields.entrySet()) {
                String fieldPath = entry.getKey();
                FieldTypeInfo.MutableTypeSet types = entry.getValue();
                mergeInto.compute(fieldPath, (k, v) -> {
                    if (v == null) {
                        return new FieldTypeInfo.MutableTypeSet(types.getByteValue());
                    }
                    return v.merge(types.getByteValue());
                });
            }
        }

        @Override
        public void close() throws IOException {
            this.valueDictionary.close();
        }
    }
}

