/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedCommonFormatColumnHandler
implements DimensionHandler<StructuredData, StructuredData, StructuredData> {
    private static Comparator<ColumnValueSelector> COMPARATOR = (s1, s2) -> StructuredData.COMPARATOR.compare(StructuredData.wrap(s1.getObject()), StructuredData.wrap(s2.getObject()));
    private final String name;

    public NestedCommonFormatColumnHandler(String name) {
        this.name = name;
    }

    @Override
    public String getDimensionName() {
        return this.name;
    }

    @Override
    public DimensionSpec getDimensionSpec() {
        return new DefaultDimensionSpec(this.name, this.name, ColumnType.NESTED_DATA);
    }

    @Override
    public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
        return new AutoTypeColumnSchema(this.name);
    }

    @Override
    public DimensionIndexer<StructuredData, StructuredData, StructuredData> makeIndexer(boolean useMaxMemoryEstimates) {
        return new AutoTypeColumnIndexer();
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        return new AutoTypeColumnMerger(this.name, indexSpec, segmentWriteOutMedium, closer);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(StructuredData dimVals) {
        return 1;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableObjectColumnValueSelector();
    }
}

