/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.nested.ValueDictionary;

public class NestedDataColumnIndexer
implements DimensionIndexer<StructuredData, StructuredData, StructuredData> {
    private static final ColumnFormat FORMAT = new NestedDataComplexTypeSerde.NestedColumnFormatV4();
    protected volatile boolean hasNulls = false;
    protected SortedMap<String, FieldIndexer> fieldIndexers = new TreeMap<String, FieldIndexer>();
    protected final ValueDictionary globalDictionary = new ValueDictionary();
    int estimatedFieldKeySize = 0;
    protected final StructuredDataProcessor indexerProcessor = new StructuredDataProcessor(){

        @Override
        public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
            if (fieldValue != null) {
                String fieldName = NestedPathFinder.toNormalizedJsonPath(fieldPath);
                ExprEval eval = ExprEval.bestEffortOf(fieldValue);
                FieldIndexer fieldIndexer = (FieldIndexer)NestedDataColumnIndexer.this.fieldIndexers.get(fieldName);
                if (fieldIndexer == null) {
                    NestedDataColumnIndexer.this.estimatedFieldKeySize += StructuredDataProcessor.estimateStringSize(fieldName);
                    fieldIndexer = new FieldIndexer(NestedDataColumnIndexer.this.globalDictionary);
                    NestedDataColumnIndexer.this.fieldIndexers.put(fieldName, fieldIndexer);
                }
                return fieldIndexer.processValue(eval);
            }
            return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
        }

        @Override
        @Nullable
        public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
            return null;
        }
    };

    @Override
    public EncodedKeyComponent<StructuredData> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        StructuredData data;
        long oldDictSizeInBytes = this.globalDictionary.sizeInBytes();
        int oldFieldKeySize = this.estimatedFieldKeySize;
        if (dimValues == null) {
            this.hasNulls = true;
            data = null;
        } else {
            data = dimValues instanceof StructuredData ? (StructuredData)dimValues : new StructuredData(dimValues);
        }
        StructuredDataProcessor.ProcessResults info = this.indexerProcessor.processFields(data == null ? null : data.getValue());
        long effectiveSizeBytes = info.getEstimatedSize();
        effectiveSizeBytes += this.globalDictionary.sizeInBytes() - oldDictSizeInBytes;
        return new EncodedKeyComponent<StructuredData>(data, effectiveSizeBytes += (long)(this.estimatedFieldKeySize - oldFieldKeySize));
    }

    @Override
    public void setSparseIndexed() {
        this.hasNulls = true;
    }

    @Override
    public StructuredData getUnsortedEncodedValueFromSorted(StructuredData sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<StructuredData> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public StructuredData getMinValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public StructuredData getMaxValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getCardinality() {
        return this.globalDictionary.getCardinality();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        int dimIndex = desc.getIndex();
        final ColumnValueSelector<?> rootLiteralSelector = this.getRootLiteralValueSelector(currEntry, dimIndex);
        if (rootLiteralSelector != null) {
            return new BaseSingleValueDimensionSelector(){

                @Override
                @Nullable
                protected String getValue() {
                    Object o = rootLiteralSelector.getObject();
                    if (o == null) {
                        return null;
                    }
                    return o.toString();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }
        throw new UOE("makeDimensionSelector is not supported, column [%s] is [%s] typed and should only use makeColumnValueSelector", spec.getOutputName(), ColumnType.NESTED_DATA);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        ColumnValueSelector<?> rootLiteralSelector = this.getRootLiteralValueSelector(currEntry, dimIndex);
        if (rootLiteralSelector != null) {
            return rootLiteralSelector;
        }
        return new ObjectColumnSelector<StructuredData>(){

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            @Nullable
            public StructuredData getObject() {
                Object[] dims = currEntry.get().getDims();
                if (0 <= dimIndex && dimIndex < dims.length) {
                    return (StructuredData)dims[dimIndex];
                }
                return null;
            }

            @Override
            public Class<StructuredData> classOfObject() {
                return StructuredData.class;
            }
        };
    }

    private ColumnType getLogicalType() {
        if (this.fieldIndexers.size() == 1 && this.fieldIndexers.containsKey("$")) {
            FieldIndexer rootField = (FieldIndexer)this.fieldIndexers.get("$");
            ColumnType singleType = rootField.getTypes().getSingleType();
            return singleType == null ? ColumnType.NESTED_DATA : singleType;
        }
        return ColumnType.NESTED_DATA;
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        return ColumnCapabilitiesImpl.createDefault().setType(this.getLogicalType()).setHasNulls(this.hasNulls);
    }

    @Override
    public ColumnFormat getFormat() {
        return FORMAT;
    }

    public SortedValueDictionary getSortedValueLookups() {
        return this.globalDictionary.getSortedCollector();
    }

    public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        for (Map.Entry<String, FieldIndexer> entry : this.fieldIndexers.entrySet()) {
            if (entry.getValue().getTypes().isEmpty()) continue;
            fields.put(entry.getKey(), entry.getValue().getTypes());
        }
        return fields;
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return StructuredData.COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable StructuredData key) {
        return Objects.hash(key);
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(StructuredData key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(final ColumnValueSelector selectorWithUnsortedValues) {
        FieldIndexer rootIndexer = (FieldIndexer)this.fieldIndexers.get("$");
        if (this.fieldIndexers.size() == 1 && rootIndexer != null && rootIndexer.isSingleType()) {
            return new ColumnValueSelector<StructuredData>(){

                @Override
                public boolean isNull() {
                    return selectorWithUnsortedValues.isNull();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    selectorWithUnsortedValues.inspectRuntimeShape(inspector);
                }

                @Override
                @Nullable
                public StructuredData getObject() {
                    return StructuredData.wrap(selectorWithUnsortedValues.getObject());
                }

                @Override
                public float getFloat() {
                    return selectorWithUnsortedValues.getFloat();
                }

                @Override
                public double getDouble() {
                    return selectorWithUnsortedValues.getDouble();
                }

                @Override
                public long getLong() {
                    return selectorWithUnsortedValues.getLong();
                }

                @Override
                public Class<StructuredData> classOfObject() {
                    return StructuredData.class;
                }
            };
        }
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(StructuredData key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Nullable
    private ColumnValueSelector<?> getRootLiteralValueSelector(final IncrementalIndexRowHolder currEntry, final int dimIndex) {
        if (this.fieldIndexers.size() > 1) {
            return null;
        }
        FieldIndexer root = (FieldIndexer)this.fieldIndexers.get("$");
        if (root == null || !root.isSingleType()) {
            return null;
        }
        return new ColumnValueSelector<Object>(){

            @Override
            public boolean isNull() {
                Object o = this.getObject();
                return !(o instanceof Number);
            }

            @Override
            public float getFloat() {
                Object value = this.getObject();
                if (value == null) {
                    return 0.0f;
                }
                return ((Number)value).floatValue();
            }

            @Override
            public double getDouble() {
                Object value = this.getObject();
                if (value == null) {
                    return 0.0;
                }
                return ((Number)value).doubleValue();
            }

            @Override
            public long getLong() {
                Object value = this.getObject();
                if (value == null) {
                    return 0L;
                }
                return ((Number)value).longValue();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            @Nullable
            public Object getObject() {
                StructuredData data;
                Object[] dims = currEntry.get().getDims();
                if (0 <= dimIndex && dimIndex < dims.length && (data = (StructuredData)dims[dimIndex]) != null) {
                    return ExprEval.bestEffortOf(data.getValue()).valueOrDefault();
                }
                return null;
            }

            @Override
            public Class<?> classOfObject() {
                return Object.class;
            }
        };
    }

    static class FieldIndexer {
        private final ValueDictionary valueDictionary;
        private final FieldTypeInfo.MutableTypeSet typeSet;

        FieldIndexer(ValueDictionary valueDictionary) {
            this.valueDictionary = valueDictionary;
            this.typeSet = new FieldTypeInfo.MutableTypeSet();
        }

        private StructuredDataProcessor.ProcessedValue<?> processValue(ExprEval<?> eval) {
            ColumnType columnType = ExpressionType.toColumnType(eval.type());
            switch ((ValueType)columnType.getType()) {
                case LONG: {
                    this.typeSet.add(ColumnType.LONG);
                    int sizeEstimate = this.valueDictionary.addLongValue(eval.asLong());
                    return new StructuredDataProcessor.ProcessedValue<Long>(eval.asLong(), sizeEstimate);
                }
                case DOUBLE: {
                    this.typeSet.add(ColumnType.DOUBLE);
                    int sizeEstimate = this.valueDictionary.addDoubleValue(eval.asDouble());
                    return new StructuredDataProcessor.ProcessedValue<Double>(eval.asDouble(), sizeEstimate);
                }
                case STRING: {
                    this.typeSet.add(ColumnType.STRING);
                    String asString = eval.asString();
                    int sizeEstimate = this.valueDictionary.addStringValue(asString);
                    return new StructuredDataProcessor.ProcessedValue<String>(asString, sizeEstimate);
                }
            }
            throw new IAE("Unhandled type: %s", columnType);
        }

        public FieldTypeInfo.MutableTypeSet getTypes() {
            return this.typeSet;
        }

        public boolean isSingleType() {
            return this.typeSet.getSingleType() != null;
        }
    }
}

