/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.UnnestStorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class UnnestSegmentReference
implements SegmentReference {
    private static final Logger log = new Logger(UnnestSegmentReference.class);
    private final SegmentReference baseSegment;
    private final VirtualColumn unnestColumn;
    @Nullable
    private final DimFilter unnestFilter;

    public UnnestSegmentReference(SegmentReference baseSegment, VirtualColumn unnestColumn, DimFilter unnestFilter) {
        this.baseSegment = baseSegment;
        this.unnestColumn = unnestColumn;
        this.unnestFilter = unnestFilter;
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        Closer closer = Closer.create();
        try {
            boolean acquireFailed = this.baseSegment.acquireReferences().map(closeable -> {
                closer.register(closeable);
                return false;
            }).orElse(true);
            if (acquireFailed) {
                CloseableUtils.closeAndWrapExceptions(closer);
                return Optional.empty();
            }
            return Optional.of(closer);
        }
        catch (Throwable e) {
            CloseableUtils.closeAndSuppressExceptions(closer, e::addSuppressed);
            log.warn(e, "Exception encountered while trying to acquire reference", new Object[0]);
            return Optional.empty();
        }
    }

    @Override
    public SegmentId getId() {
        return this.baseSegment.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.baseSegment.getDataInterval();
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new UnnestStorageAdapter(this.baseSegment.asStorageAdapter(), this.unnestColumn, this.unnestFilter);
    }

    @Override
    public void close() throws IOException {
        this.baseSegment.close();
    }
}

