/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class DimensionPredicateFilter
implements Filter {
    protected final String dimension;
    protected final DruidPredicateFactory predicateFactory;
    protected final String basePredicateString;
    protected final ExtractionFn extractionFn;
    protected final FilterTuning filterTuning;

    public DimensionPredicateFilter(String dimension, DruidPredicateFactory predicateFactory, ExtractionFn extractionFn) {
        this(dimension, predicateFactory, extractionFn, null);
    }

    public DimensionPredicateFilter(String dimension, DruidPredicateFactory predicateFactory, ExtractionFn extractionFn, FilterTuning filterTuning) {
        Preconditions.checkNotNull((Object)predicateFactory, (Object)"predicateFactory");
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.basePredicateString = predicateFactory.toString();
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.predicateFactory = extractionFn == null ? predicateFactory : new DelegatingStringPredicateFactory(predicateFactory, extractionFn);
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        return Filters.makePredicateIndex(this.dimension, selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.predicateFactory);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format("%s(%s) = %s", this.extractionFn, this.dimension, this.basePredicateString);
        }
        return StringUtils.format("%s = %s", this.dimension, this.basePredicateString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionPredicateFilter that = (DimensionPredicateFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.basePredicateString, that.basePredicateString) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.basePredicateString, this.extractionFn, this.filterTuning);
    }

    @VisibleForTesting
    static class DelegatingStringPredicateFactory
    implements DruidPredicateFactory {
        private final Predicate<String> baseStringPredicate;
        private final DruidPredicateFactory predicateFactory;
        private final ExtractionFn extractionFn;

        DelegatingStringPredicateFactory(DruidPredicateFactory predicateFactory, ExtractionFn extractionFn) {
            this.predicateFactory = predicateFactory;
            this.baseStringPredicate = predicateFactory.makeStringPredicate();
            this.extractionFn = extractionFn;
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            return input -> this.baseStringPredicate.apply((Object)this.extractionFn.apply((String)input));
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    return baseStringPredicate.apply((Object)extractionFn.apply(input));
                }

                @Override
                public boolean applyNull() {
                    return baseStringPredicate.apply((Object)extractionFn.apply(null));
                }
            };
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return new DruidFloatPredicate(){

                @Override
                public boolean applyFloat(float input) {
                    return baseStringPredicate.apply((Object)extractionFn.apply(Float.valueOf(input)));
                }

                @Override
                public boolean applyNull() {
                    return baseStringPredicate.apply((Object)extractionFn.apply(null));
                }
            };
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return new DruidDoublePredicate(){

                @Override
                public boolean applyDouble(double input) {
                    return baseStringPredicate.apply((Object)extractionFn.apply(input));
                }

                @Override
                public boolean applyNull() {
                    return baseStringPredicate.apply((Object)extractionFn.apply(null));
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelegatingStringPredicateFactory that = (DelegatingStringPredicateFactory)o;
            return Objects.equals(this.predicateFactory, that.predicateFactory) && Objects.equals(this.extractionFn, that.extractionFn);
        }

        public int hashCode() {
            return Objects.hash(this.predicateFactory, this.extractionFn);
        }
    }
}

