/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class NotFilter
implements Filter {
    private final Filter baseFilter;

    public NotFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(final ColumnIndexSelector selector) {
        final BitmapColumnIndex baseIndex = this.baseFilter.getBitmapColumnIndex(selector);
        if (baseIndex != null && baseIndex.getIndexCapabilities().isInvertible()) {
            return new BitmapColumnIndex(){

                @Override
                public ColumnIndexCapabilities getIndexCapabilities() {
                    return baseIndex.getIndexCapabilities();
                }

                @Override
                public double estimateSelectivity(int totalRows) {
                    return 1.0 - NotFilter.this.baseFilter.estimateSelectivity(selector);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    return bitmapResultFactory.complement(baseIndex.computeBitmapResult(bitmapResultFactory), selector.getNumRows());
                }
            };
        }
        return null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ValueMatcher baseMatcher = this.baseFilter.makeMatcher(factory);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return !baseMatcher.matches();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseMatcher", baseMatcher);
            }
        };
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(final VectorColumnSelectorFactory factory) {
        final VectorValueMatcher baseMatcher = this.baseFilter.makeVectorMatcher(factory);
        return new BaseVectorValueMatcher(baseMatcher){
            final VectorMatch scratch;
            {
                super(selector);
                this.scratch = VectorMatch.wrap(new int[factory.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch baseMatch = baseMatcher.match(mask);
                this.scratch.copyFrom(mask);
                this.scratch.removeAll(baseMatch);
                assert (this.scratch.isValid(mask));
                return this.scratch;
            }
        };
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.baseFilter.canVectorizeMatcher(inspector);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.baseFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return this.baseFilter.supportsRequiredColumnRewrite();
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return new NotFilter(this.baseFilter.rewriteRequiredColumns(columnRewrites));
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return this.baseFilter.supportsSelectivityEstimation(columnSelector, indexSelector);
    }

    public String toString() {
        return StringUtils.format("~(%s)", this.baseFilter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotFilter notFilter = (NotFilter)o;
        return Objects.equals(this.baseFilter, notFilter.baseFilter);
    }

    public int hashCode() {
        return Objects.hash(1, this.baseFilter);
    }

    public Filter getBaseFilter() {
        return this.baseFilter;
    }
}

