/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import javax.annotation.Nullable;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.DateTime;

public class PostJoinCursor
implements Cursor {
    private final Cursor baseCursor;
    private final ColumnSelectorFactory columnSelectorFactory;
    @Nullable
    private final ValueMatcher valueMatcher;
    @Nullable
    private final Filter postJoinFilter;

    private PostJoinCursor(Cursor baseCursor, VirtualColumns virtualColumns, @Nullable Filter filter) {
        this.baseCursor = baseCursor;
        this.columnSelectorFactory = virtualColumns.wrap(baseCursor.getColumnSelectorFactory());
        this.valueMatcher = filter == null ? null : filter.makeMatcher(this.columnSelectorFactory);
        this.postJoinFilter = filter;
    }

    public static PostJoinCursor wrap(Cursor baseCursor, VirtualColumns virtualColumns, @Nullable Filter filter) {
        PostJoinCursor postJoinCursor = new PostJoinCursor(baseCursor, virtualColumns, filter);
        postJoinCursor.advanceToMatch();
        return postJoinCursor;
    }

    private void advanceToMatch() {
        if (this.valueMatcher != null) {
            while (!this.isDone() && !this.valueMatcher.matches()) {
                this.baseCursor.advanceUninterruptibly();
            }
        }
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Override
    public DateTime getTime() {
        return this.baseCursor.getTime();
    }

    @Nullable
    public Filter getPostJoinFilter() {
        return this.postJoinFilter;
    }

    @Override
    public void advance() {
        this.advanceUninterruptibly();
        BaseQuery.checkInterrupted();
    }

    @Override
    public void advanceUninterruptibly() {
        this.baseCursor.advanceUninterruptibly();
        this.advanceToMatch();
    }

    @Override
    public boolean isDone() {
        return this.baseCursor.isDone();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.baseCursor.isDoneOrInterrupted();
    }

    @Override
    public void reset() {
        this.baseCursor.reset();
        this.advanceToMatch();
    }
}

