/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.FieldTypeInfo;

public interface NestedCommonFormatColumn
extends BaseColumn {
    default public Indexed<String> getStringDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Long> getLongDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Double> getDoubleDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Object[]> getArrayDictionary() {
        return Indexed.empty();
    }

    default public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        FieldTypeInfo.MutableTypeSet rootOnlyType = new FieldTypeInfo.MutableTypeSet().add(this.getLogicalType());
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        fields.put("$", rootOnlyType);
        return fields;
    }

    public ColumnType getLogicalType();

    public static class Format
    implements ColumnFormat {
        private final ColumnType logicalType;
        private final boolean hasNulls;

        public Format(ColumnType logicalType, boolean hasNulls) {
            this.logicalType = logicalType;
            this.hasNulls = hasNulls;
        }

        @Override
        public ColumnType getLogicalType() {
            return this.logicalType;
        }

        @Override
        public DimensionHandler getColumnHandler(String columnName) {
            return new NestedCommonFormatColumnHandler(columnName);
        }

        @Override
        public DimensionSchema getColumnSchema(String columnName) {
            return new AutoTypeColumnSchema(columnName);
        }

        @Override
        public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
            if (otherFormat == null) {
                return this;
            }
            if (otherFormat instanceof Format) {
                boolean otherHasNulls = ((Format)otherFormat).hasNulls;
                if (!this.getLogicalType().equals(otherFormat.getLogicalType())) {
                    return new Format(ColumnType.NESTED_DATA, this.hasNulls || otherHasNulls);
                }
                return new Format(this.logicalType, this.hasNulls || otherHasNulls);
            }
            throw new ISE("Cannot merge columns of type[%s] and format[%s] and with [%s] and [%s]", this.logicalType, this.getClass().getName(), otherFormat.getLogicalType(), otherFormat.getClass().getName());
        }

        @Override
        public ColumnCapabilities toColumnCapabilities() {
            if (this.logicalType.isPrimitive() || this.logicalType.isArray()) {
                return ColumnCapabilitiesImpl.createDefault().setType(this.logicalType).setDictionaryEncoded(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true).setHasBitmapIndexes(true).setFilterable(true).setHasNulls(this.hasNulls);
            }
            return ColumnCapabilitiesImpl.createDefault().setType(this.logicalType).setHasNulls(this.hasNulls).setFilterable(true);
        }
    }
}

