/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.NumericRangeIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.FieldTypeInfo;

public class NestedFieldColumnIndexSupplier<TStringDictionary extends Indexed<ByteBuffer>>
implements ColumnIndexSupplier {
    @Nullable
    private final ColumnType singleType;
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final Supplier<FixedIndexed<Integer>> localDictionarySupplier;
    private final Supplier<TStringDictionary> globalStringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> globalLongDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> globalDoubleDictionarySupplier;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> arrayElementBitmaps;
    @Nullable
    private final Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
    private final int adjustLongId;
    private final int adjustDoubleId;
    private final ColumnConfig columnConfig;
    private final int numRows;

    public NestedFieldColumnIndexSupplier(FieldTypeInfo.TypeSet types, BitmapFactory bitmapFactory, ColumnConfig columnConfig, GenericIndexed<ImmutableBitmap> bitmaps, Supplier<FixedIndexed<Integer>> localDictionarySupplier, Supplier<TStringDictionary> globalStringDictionarySupplier, Supplier<FixedIndexed<Long>> globalLongDictionarySupplier, Supplier<FixedIndexed<Double>> globalDoubleDictionarySupplier, @Nullable Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier, @Nullable GenericIndexed<ImmutableBitmap> arrayElementBitmaps, int numRows) {
        this.singleType = types.getSingleType();
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.localDictionarySupplier = localDictionarySupplier;
        this.globalStringDictionarySupplier = globalStringDictionarySupplier;
        this.globalLongDictionarySupplier = globalLongDictionarySupplier;
        this.globalDoubleDictionarySupplier = globalDoubleDictionarySupplier;
        this.arrayElementDictionarySupplier = arrayElementDictionarySupplier;
        this.arrayElementBitmaps = arrayElementBitmaps;
        this.adjustLongId = ((Indexed)globalStringDictionarySupplier.get()).size();
        this.adjustDoubleId = this.adjustLongId + ((FixedIndexed)globalLongDictionarySupplier.get()).size();
        this.columnConfig = columnConfig;
        this.numRows = numRows;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = (Integer)((FixedIndexed)this.localDictionarySupplier.get()).get(0) == 0 ? new SimpleImmutableBitmapIndex(this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new NestedFieldDictionaryEncodedStringValueIndex();
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case STRING: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedStringValueSetIndex();
                    }
                    if (clazz.equals(LexicographicalRangeIndex.class)) {
                        return (T)new NestedStringLexicographicalRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedStringPredicateIndex();
                    }
                    return null;
                }
                case LONG: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedLongValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndex.class)) {
                        return (T)new NestedLongNumericRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedLongPredicateIndex();
                    }
                    return null;
                }
                case DOUBLE: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedDoubleValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndex.class)) {
                        return (T)new NestedDoubleNumericRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedDoublePredicateIndex();
                    }
                    return null;
                }
            }
            return null;
        }
        if (clazz.equals(StringValueSetIndex.class)) {
            return (T)new NestedVariantValueSetIndex();
        }
        if (clazz.equals(DruidPredicateIndex.class)) {
            return (T)new NestedVariantPredicateIndex();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private <T> IntIntPair getLocalRangeFromDictionary(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, Indexed<Integer> localDictionary, Indexed<T> globalDictionary, int adjust) {
        int found;
        int globalStartIndex = startValue == null ? (adjust == 0 ? 1 : adjust) : ((found = globalDictionary.indexOf(startValue)) >= 0 ? adjust + (startStrict ? found + 1 : found) : adjust + -(found + 1));
        int globalEndIndex = endValue == null ? globalDictionary.size() + adjust : ((found = globalDictionary.indexOf(endValue)) >= 0 ? adjust + (endStrict ? found : found + 1) : adjust + -(found + 1));
        if (globalStartIndex == (globalEndIndex = Math.max(globalStartIndex, globalEndIndex))) {
            return new IntIntImmutablePair(0, 0);
        }
        int localFound = localDictionary.indexOf(globalStartIndex);
        int localStartIndex = localFound < 0 ? -(localFound + 1) : localFound;
        int localEndFound = localDictionary.indexOf(globalEndIndex);
        int localEndIndex = localEndFound < 0 ? -(localEndFound + 1) : localEndFound;
        localStartIndex = Math.min(localStartIndex, localDictionary.size());
        localEndIndex = Math.max(localStartIndex, Math.min(localDictionary.size(), localEndIndex));
        return new IntIntImmutablePair(localStartIndex, localEndIndex);
    }

    @Nullable
    private <T> BitmapColumnIndex makeRangeIndex(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, Indexed<Integer> localDictionary, Indexed<T> globalDictionary, int adjust) {
        IntIntPair localRange = this.getLocalRangeFromDictionary(startValue, startStrict, endValue, endStrict, localDictionary, globalDictionary, adjust);
        final int startIndex = localRange.leftInt();
        final int endIndex = localRange.rightInt();
        int size = endIndex - startIndex;
        if (ColumnIndexSupplier.skipComputingRangeIndexes(this.columnConfig, this.numRows, size)) {
            return null;
        }
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final IntIterator rangeIterator;
                    {
                        this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rangeIterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return NestedFieldColumnIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                    }
                };
            }
        };
    }

    private class NestedVariantPredicateIndex
    extends NestedVariantLiteralIndex
    implements DruidPredicateIndex {
        private NestedVariantPredicateIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            if (ColumnIndexSupplier.skipComputingPredicateIndexes(NestedFieldColumnIndexSupplier.this.columnConfig, NestedFieldColumnIndexSupplier.this.numRows, this.localDictionary.size())) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidLongPredicate longPredicate;
                        final DruidDoublePredicate doublePredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final Predicate stringPredicate;
                        final Iterator iterator;
                        {
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.iterator = NestedVariantPredicateIndex.this.localDictionary.iterator();
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue >= NestedFieldColumnIndexSupplier.this.adjustDoubleId ? this.doublePredicate.applyDouble((Double)NestedVariantPredicateIndex.this.doubleDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustDoubleId)) : (nextValue >= NestedFieldColumnIndexSupplier.this.adjustLongId ? this.longPredicate.applyLong((Long)NestedVariantPredicateIndex.this.longDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustLongId)) : this.stringPredicate.apply((Object)StringUtils.fromUtf8Nullable((ByteBuffer)NestedVariantPredicateIndex.this.stringDictionary.get(nextValue))));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedVariantValueSetIndex
    extends NestedVariantLiteralIndex
    implements StringValueSetIndex {
        private NestedVariantValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntListIterator iterator = NestedVariantValueSetIndex.this.getIndexes(value).iterator();
                    return () -> this.lambda$getBitmapIterable$0((IntIterator)iterator);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final IntIterator iterator) {
                    return new Iterator<ImmutableBitmap>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return NestedFieldColumnIndexSupplier.this.getBitmap(iterator.nextInt());
                        }
                    };
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        IntIterator nextIterator;
                        final Iterator iterator;
                        {
                            this.iterator = values.iterator();
                            this.nextIterator = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                            }
                            return this.nextIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                                if (!this.nextIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                            }
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.nextIterator.nextInt());
                        }

                        private void findNext() {
                            while ((this.nextIterator == null || !this.nextIterator.hasNext()) && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.nextIterator = NestedVariantValueSetIndex.this.getIndexes(nextValue).iterator();
                            }
                        }
                    };
                }
            };
        }
    }

    private abstract class NestedVariantLiteralIndex {
        final FixedIndexed<Integer> localDictionary;
        final Indexed<ByteBuffer> stringDictionary;
        final FixedIndexed<Long> longDictionary;
        final FixedIndexed<Double> doubleDictionary;

        private NestedVariantLiteralIndex() {
            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
        }

        IntList getIndexes(@Nullable String value) {
            int localId;
            Double someDouble;
            int localId2;
            Long someLong;
            int localId3;
            IntArrayList intList = new IntArrayList();
            if (value == null) {
                intList.add(this.localDictionary.indexOf(0));
                return intList;
            }
            int globalId = this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(value));
            if (globalId >= 0 && (localId3 = this.localDictionary.indexOf(globalId)) >= 0) {
                intList.add(localId3);
            }
            if ((someLong = GuavaUtils.tryParseLong(value)) != null && (globalId = this.longDictionary.indexOf(someLong)) >= 0 && (localId2 = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)) >= 0) {
                intList.add(localId2);
            }
            if ((someDouble = Doubles.tryParse((String)value)) != null && (globalId = this.doubleDictionary.indexOf(someDouble)) >= 0 && (localId = this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)) >= 0) {
                intList.add(localId);
            }
            return intList;
        }
    }

    private class NestedDoublePredicateIndex
    implements DruidPredicateIndex {
        private NestedDoublePredicateIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            if (ColumnIndexSupplier.skipComputingPredicateIndexes(NestedFieldColumnIndexSupplier.this.columnConfig, NestedFieldColumnIndexSupplier.this.numRows, localDictionary.size())) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidDoublePredicate doublePredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final FixedIndexed localDictionary;
                        final FixedIndexed doubleDictionary;
                        final Iterator iterator;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.iterator = this.localDictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue == 0 ? this.doublePredicate.applyNull() : this.doublePredicate.applyDouble((Double)this.doubleDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustDoubleId));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedDoubleNumericRangeIndex
    implements NumericRangeIndex {
        private NestedDoubleNumericRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(startValue != null ? Double.valueOf(startValue.doubleValue()) : null, startStrict, endValue != null ? Double.valueOf(endValue.doubleValue()) : null, endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get(), NestedFieldColumnIndexSupplier.this.adjustDoubleId);
        }
    }

    private class NestedDoubleValueSetIndex
    implements StringValueSetIndex {
        private NestedDoubleValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Double doubleValue = Strings.isNullOrEmpty((String)value) ? null : Doubles.tryParse((String)value);
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Double> doubleDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                }

                @Override
                public double estimateSelectivity(int totalRows) {
                    if (doubleValue == null) {
                        if (inputNull) {
                            return (double)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)).size() / (double)totalRows;
                        }
                        return 0.0;
                    }
                    int globalId = this.doubleDictionary.indexOf(doubleValue);
                    if (globalId < 0) {
                        return 0.0;
                    }
                    return (double)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    if (doubleValue == null) {
                        if (inputNull) {
                            return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int globalId = this.doubleDictionary.indexOf(doubleValue);
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustDoubleId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    DoubleArraySet doubles = new DoubleArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Double theValue = Doubles.tryParse((String)value);
                        if (theValue == null) continue;
                        doubles.add(theValue.doubleValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((DoubleSet)doubles, doNullCheck);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final DoubleSet doubles, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final DoubleIterator iterator;
                        int next;
                        boolean nullChecked;
                        final FixedIndexed localDictionary;
                        final FixedIndexed doubleDictionary;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
                            this.iterator = doubles.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                double nextValue = this.iterator.nextDouble();
                                this.next = this.localDictionary.indexOf(this.doubleDictionary.indexOf(nextValue) + NestedFieldColumnIndexSupplier.this.adjustDoubleId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongPredicateIndex
    implements DruidPredicateIndex {
        private NestedLongPredicateIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            if (ColumnIndexSupplier.skipComputingPredicateIndexes(NestedFieldColumnIndexSupplier.this.columnConfig, NestedFieldColumnIndexSupplier.this.numRows, localDictionary.size())) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidLongPredicate longPredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final FixedIndexed longDictionary;
                        final Iterator iterator;
                        {
                            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.iterator = localDictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue == 0 ? this.longPredicate.applyNull() : this.longPredicate.applyLong((Long)this.longDictionary.get(nextValue - NestedFieldColumnIndexSupplier.this.adjustLongId));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongNumericRangeIndex
    implements NumericRangeIndex {
        private NestedLongNumericRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(startValue != null ? Long.valueOf(startValue.longValue()) : null, startStrict, endValue != null ? Long.valueOf(endValue.longValue()) : null, endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get(), NestedFieldColumnIndexSupplier.this.adjustLongId);
        }
    }

    private class NestedLongValueSetIndex
    implements StringValueSetIndex {
        private NestedLongValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Long longValue = GuavaUtils.tryParseLong(value);
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final FixedIndexed<Long> longDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                }

                @Override
                public double estimateSelectivity(int totalRows) {
                    if (longValue == null) {
                        if (inputNull) {
                            return (double)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)).size() / (double)totalRows;
                        }
                        return 0.0;
                    }
                    int globalId = this.longDictionary.indexOf(longValue);
                    if (globalId < 0) {
                        return 0.0;
                    }
                    return (double)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    if (longValue == null) {
                        if (inputNull) {
                            return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(0)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    int globalId = this.longDictionary.indexOf(longValue);
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId + NestedFieldColumnIndexSupplier.this.adjustLongId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    LongArraySet longs = new LongArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Long theValue = GuavaUtils.tryParseLong(value);
                        if (theValue == null) continue;
                        longs.add(theValue.longValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((LongSet)longs, doNullCheck);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final LongSet longs, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final LongIterator iterator;
                        int next;
                        boolean nullChecked;
                        final FixedIndexed localDictionary;
                        final FixedIndexed longDictionary;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
                            this.iterator = longs.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                long nextValue = this.iterator.nextLong();
                                this.next = this.localDictionary.indexOf(this.longDictionary.indexOf(nextValue) + NestedFieldColumnIndexSupplier.this.adjustLongId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedStringPredicateIndex
    implements DruidPredicateIndex {
        private NestedStringPredicateIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            if (ColumnIndexSupplier.skipComputingPredicateIndexes(NestedFieldColumnIndexSupplier.this.columnConfig, NestedFieldColumnIndexSupplier.this.numRows, localDictionary.size())) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        int index;
                        boolean nextSet;
                        final Indexed stringDictionary;
                        final Predicate stringPredicate;
                        final Iterator iterator;
                        {
                            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.iterator = localDictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = this.stringPredicate.apply((Object)StringUtils.fromUtf8Nullable((ByteBuffer)this.stringDictionary.get(nextValue)));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedStringLexicographicalRangeIndex
    implements LexicographicalRangeIndex {
        private NestedStringLexicographicalRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            return NestedFieldColumnIndexSupplier.this.makeRangeIndex(StringUtils.toUtf8ByteBuffer(NullHandling.emptyToNullIfNeeded(startValue)), startStrict, StringUtils.toUtf8ByteBuffer(NullHandling.emptyToNullIfNeeded(endValue)), endStrict, (Indexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get(), (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get(), 0);
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict, final Predicate<String> matcher) {
            final FixedIndexed localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            final Indexed stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            IntIntPair range = NestedFieldColumnIndexSupplier.this.getLocalRangeFromDictionary(StringUtils.toUtf8ByteBuffer(startValue), startStrict, StringUtils.toUtf8ByteBuffer(endValue), endStrict, localDictionary, stringDictionary, 0);
            final int start = range.leftInt();
            final int end = range.rightInt();
            if (ColumnIndexSupplier.skipComputingRangeIndexes(NestedFieldColumnIndexSupplier.this.columnConfig, NestedFieldColumnIndexSupplier.this.numRows, end - start)) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int currIndex;
                        int found;
                        {
                            this.currIndex = start;
                            this.found = this.findNext();
                        }

                        private int findNext() {
                            while (this.currIndex < end && !matcher.apply((Object)StringUtils.fromUtf8Nullable((ByteBuffer)stringDictionary.get((Integer)localDictionary.get(this.currIndex))))) {
                                ++this.currIndex;
                            }
                            if (this.currIndex < end) {
                                return this.currIndex++;
                            }
                            return -1;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.found != -1;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            int cur = this.found;
                            if (cur == -1) {
                                throw new NoSuchElementException();
                            }
                            this.found = this.findNext();
                            return NestedFieldColumnIndexSupplier.this.getBitmap(cur);
                        }
                    };
                }
            };
        }
    }

    private class NestedStringValueSetIndex
    implements StringValueSetIndex {
        private NestedStringValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Integer> localDictionary;
                final Indexed<ByteBuffer> stringDictionary;
                {
                    this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                    this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                }

                @Override
                public double estimateSelectivity(int totalRows) {
                    int globalId = this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(value));
                    if (globalId < 0) {
                        return 0.0;
                    }
                    return (double)NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId)).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    int globalId = this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(value));
                    if (globalId < 0) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldColumnIndexSupplier.this.getBitmap(this.localDictionary.indexOf(globalId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        final FixedIndexed localDictionary;
                        final Indexed stringDictionary;
                        final Iterator iterator;
                        {
                            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
                            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
                            this.iterator = values.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.next = this.localDictionary.indexOf(this.stringDictionary.indexOf(StringUtils.toUtf8ByteBuffer(nextValue)));
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedFieldDictionaryEncodedStringValueIndex
    implements DictionaryEncodedStringValueIndex {
        final FixedIndexed<Integer> localDictionary;
        final Indexed<ByteBuffer> stringDictionary;
        final FixedIndexed<Long> longDictionary;
        final FixedIndexed<Double> doubleDictionary;

        private NestedFieldDictionaryEncodedStringValueIndex() {
            this.localDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.localDictionarySupplier.get();
            this.stringDictionary = (Indexed)NestedFieldColumnIndexSupplier.this.globalStringDictionarySupplier.get();
            this.longDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalLongDictionarySupplier.get();
            this.doubleDictionary = (FixedIndexed)NestedFieldColumnIndexSupplier.this.globalDoubleDictionarySupplier.get();
        }

        @Override
        public int getCardinality() {
            return this.localDictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            int globalIndex = this.localDictionary.get(index);
            if (globalIndex < NestedFieldColumnIndexSupplier.this.adjustLongId) {
                return StringUtils.fromUtf8Nullable(this.stringDictionary.get(globalIndex));
            }
            if (globalIndex < NestedFieldColumnIndexSupplier.this.adjustDoubleId) {
                return String.valueOf(this.longDictionary.get(globalIndex - NestedFieldColumnIndexSupplier.this.adjustLongId));
            }
            return String.valueOf(this.doubleDictionary.get(globalIndex - NestedFieldColumnIndexSupplier.this.adjustDoubleId));
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return NestedFieldColumnIndexSupplier.this.bitmapFactory;
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return NestedFieldColumnIndexSupplier.this.getBitmap(idx);
        }
    }
}

