/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.NumericRangeIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.ScalarDoubleColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class ScalarDoubleColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<ColumnarDoubles> valueColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final BitmapFactory bitmapFactory;
    private final ImmutableBitmap nullValueBitmap;
    private final ColumnConfig columnConfig;
    private final int numRows;

    public static ScalarDoubleColumnAndIndexSupplier read(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version == 0) {
            try {
                int size;
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleDictionary");
                ByteBuffer doublesValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleColumn");
                Supplier doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
                Supplier<ColumnarDoubles> doubles = CompressedColumnarDoublesSuppliers.fromByteBuffer(doublesValueColumn, byteOrder);
                ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
                try (ColumnarDoubles throwAway = (ColumnarDoubles)doubles.get();){
                    size = throwAway.size();
                }
                return new ScalarDoubleColumnAndIndexSupplier(doubleDictionarySupplier, doubles, rBitmaps, bitmapSerdeFactory.getBitmapFactory(), columnConfig, size);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private ScalarDoubleColumnAndIndexSupplier(Supplier<FixedIndexed<Double>> longDictionary, Supplier<ColumnarDoubles> valueColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapFactory bitmapFactory, ColumnConfig columnConfig, int numRows) {
        this.doubleDictionarySupplier = longDictionary;
        this.valueColumnSupplier = valueColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.bitmapFactory = bitmapFactory;
        this.nullValueBitmap = valueIndexes.get(0) == null ? bitmapFactory.makeEmptyImmutableBitmap() : valueIndexes.get(0);
        this.columnConfig = columnConfig;
        this.numRows = numRows;
    }

    public NestedCommonFormatColumn get() {
        return new ScalarDoubleColumn((FixedIndexed)this.doubleDictionarySupplier.get(), (ColumnarDoubles)this.valueColumnSupplier.get(), this.nullValueBitmap);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = NullHandling.replaceWithDefault() ? new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap()) : new SimpleImmutableBitmapIndex(this.nullValueBitmap);
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new DoubleDictionaryEncodedValueSetIndex();
        }
        if (clazz.equals(StringValueSetIndex.class)) {
            return (T)new DoubleValueSetIndex();
        }
        if (clazz.equals(NumericRangeIndex.class)) {
            return (T)new DoubleNumericRangeIndex();
        }
        if (clazz.equals(DruidPredicateIndex.class)) {
            return (T)new DoublePredicateIndex();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.valueIndexes.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private class DoubleDictionaryEncodedValueSetIndex
    implements DictionaryEncodedStringValueIndex {
        private final FixedIndexed<Double> dictionary;

        private DoubleDictionaryEncodedValueSetIndex() {
            this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(idx);
        }

        @Override
        public int getCardinality() {
            return this.dictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            Double value = this.dictionary.get(index);
            return value == null ? null : String.valueOf(value);
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory;
        }
    }

    private class DoublePredicateIndex
    implements DruidPredicateIndex {
        private DoublePredicateIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            if (ColumnIndexSupplier.skipComputingPredicateIndexes(ScalarDoubleColumnAndIndexSupplier.this.columnConfig, ScalarDoubleColumnAndIndexSupplier.this.numRows, dictionary.size())) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidDoublePredicate doublePredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final Iterator iterator;
                        {
                            this.iterator = ((FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get()).iterator();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Double nextValue = (Double)this.iterator.next();
                                this.nextSet = nextValue == null ? (NullHandling.sqlCompatible() ? this.doublePredicate.applyNull() : this.doublePredicate.applyDouble(NullHandling.defaultDoubleValue())) : this.doublePredicate.applyDouble(nextValue);
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class DoubleNumericRangeIndex
    implements NumericRangeIndex {
        private DoubleNumericRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            IntIntPair range = dictionary.getRange(startValue == null ? null : Double.valueOf(startValue.doubleValue()), startStrict, endValue == null ? null : Double.valueOf(endValue.doubleValue()), endStrict);
            final int startIndex = range.leftInt();
            final int endIndex = range.rightInt();
            if (ColumnIndexSupplier.skipComputingRangeIndexes(ScalarDoubleColumnAndIndexSupplier.this.columnConfig, ScalarDoubleColumnAndIndexSupplier.this.numRows, endIndex - startIndex)) {
                return null;
            }
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final IntIterator rangeIterator;
                        {
                            this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.rangeIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                        }
                    };
                }
            };
        }
    }

    private class DoubleValueSetIndex
    implements StringValueSetIndex {
        private DoubleValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Double doubleValue = Strings.isNullOrEmpty((String)value) ? null : Doubles.tryParse((String)value);
            final FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            final int defaultValueIndex = dictionary.indexOf(NullHandling.defaultDoubleValue());
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    if (doubleValue == null) {
                        if (inputNull && NullHandling.sqlCompatible()) {
                            return (double)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0).size() / (double)totalRows;
                        }
                        return 0.0;
                    }
                    if (NullHandling.replaceWithDefault() && doubleValue.equals(NullHandling.defaultDoubleValue())) {
                        if (defaultValueIndex >= 0) {
                            return ((double)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0).size() + (double)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(defaultValueIndex).size()) / (double)totalRows;
                        }
                        return (double)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0).size() / (double)totalRows;
                    }
                    int id = dictionary.indexOf(doubleValue);
                    if (id < 0) {
                        return 0.0;
                    }
                    return (double)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    if (doubleValue == null) {
                        if (inputNull && NullHandling.sqlCompatible()) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    if (NullHandling.replaceWithDefault() && doubleValue.equals(NullHandling.defaultDoubleValue())) {
                        if (defaultValueIndex >= 0) {
                            return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0), (Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(defaultValueIndex)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0));
                    }
                    int id = dictionary.indexOf(doubleValue);
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    DoubleArraySet doubles = new DoubleArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Double theValue = Doubles.tryParse((String)value);
                        if (theValue == null) continue;
                        doubles.add(theValue.doubleValue());
                        if (!NullHandling.replaceWithDefault() || !theValue.equals(NullHandling.defaultDoubleValue())) continue;
                        needNullCheck = true;
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((DoubleSet)doubles, doNullCheck);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final DoubleSet doubles, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final DoubleIterator iterator;
                        int next;
                        boolean nullChecked;
                        final FixedIndexed dictionary;
                        {
                            this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
                            this.iterator = doubles.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                double nextValue = this.iterator.nextDouble();
                                this.next = this.dictionary.indexOf(nextValue);
                            }
                        }
                    };
                }
            };
        }
    }
}

