/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ScalarLongColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(ScalarLongColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private DictionaryIdLookup dictionaryIdLookup;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;
    private SingleValueColumnarIntsSerializer encodedValueSerializer;
    private ColumnarLongsSerializer longsSerializer;
    private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter;
    private MutableBitmap[] bitmaps;
    private ByteBuffer columnNameBytes = null;

    public ScalarLongColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.dictionaryIdLookup = new DictionaryIdLookup();
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getGlobalLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return !this.bitmaps[0].isEmpty();
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        CompressionStrategy compression = this.indexSpec.getDimensionCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, this.longDictionaryWriter.getCardinality(), compressionToUse);
        this.encodedValueSerializer.open();
        this.longsSerializer = CompressionFactory.getLongSerializer(this.name, this.segmentWriteOutMedium, StringUtils.format("%s.long_column", this.name), ByteOrder.nativeOrder(), this.indexSpec.getLongEncoding(), this.indexSpec.getDimensionCompression());
        this.longsSerializer.open();
        this.bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapIndexWriter.open();
        this.bitmapIndexWriter.setObjectsNotSorted();
        this.bitmaps = new MutableBitmap[this.longDictionaryWriter.getCardinality()];
        for (int i = 0; i < this.bitmaps.length; ++i) {
            this.bitmaps[i] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
    }

    @Override
    public void openDictionaryWriter() throws IOException {
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.longDictionaryWriter.write(null);
        this.dictionaryIdLookup.addNumericNull();
        for (Long value : longs) {
            if (value == null) continue;
            this.longDictionaryWriter.write(value);
            this.dictionaryIdLookup.addLong(value);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        Object value = StructuredData.unwrap(selector.getObject());
        ExprEval eval = ExprEval.bestEffortOf(value);
        long val = eval.asLong();
        int dictId = eval.isNumericNull() ? 0 : this.dictionaryIdLookup.lookupLong(val);
        this.encodedValueSerializer.addValue(dictId);
        this.longsSerializer.add(dictId == 0 ? 0L : val);
        this.bitmaps[dictId].add(this.rowCount);
        ++this.rowCount;
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            for (int i = 0; i < this.bitmaps.length; ++i) {
                MutableBitmap bitmap = this.bitmaps[i];
                this.bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
                this.bitmaps[i] = null;
            }
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        this.writeV0Header(channel, this.columnNameBytes);
        this.writeInternal(smoosher, this.longDictionaryWriter, "__longDictionary");
        this.writeInternal(smoosher, this.encodedValueSerializer, "__encodedColumn");
        this.writeInternal(smoosher, this.longsSerializer, "__longColumn");
        this.writeInternal(smoosher, this.bitmapIndexWriter, "__valueIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

