/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.IndexedStringDictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.IndexedStringDruidPredicateIndex;
import org.apache.druid.segment.column.IndexedUtf8LexicographicalRangeIndex;
import org.apache.druid.segment.column.IndexedUtf8ValueSetIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.StringFrontCodedDictionaryEncodedColumn;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.ScalarStringDictionaryEncodedColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class ScalarStringColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final GenericIndexed<ByteBuffer> stringDictionary;
    private final Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
    private final Supplier<ColumnarInts> encodedColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final ImmutableBitmap nullValueBitmap;
    private final BitmapFactory bitmapFactory;
    private final ColumnConfig columnConfig;
    private final int numRows;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScalarStringColumnAndIndexSupplier read(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version != 0) throw new RE("Unknown version " + version, new Object[0]);
        try {
            GenericIndexed<ByteBuffer> stringDictionary;
            Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
            SmooshedFileMapper mapper = columnBuilder.getFileMapper();
            ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__stringDictionary");
            int dictionaryStartPosition = stringDictionaryBuffer.position();
            byte dictionaryVersion = stringDictionaryBuffer.get();
            if (dictionaryVersion == 127) {
                byte encodingId = stringDictionaryBuffer.get();
                if (encodingId == 1) {
                    frontCodedStringDictionarySupplier = FrontCodedIndexed.read(stringDictionaryBuffer, byteOrder);
                    stringDictionary = null;
                } else {
                    if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", encodingId);
                    stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                    frontCodedStringDictionarySupplier = null;
                }
            } else {
                stringDictionaryBuffer.position(dictionaryStartPosition);
                stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                frontCodedStringDictionarySupplier = null;
            }
            ByteBuffer encodedValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__encodedColumn");
            CompressedVSizeColumnarIntsSupplier ints = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(encodedValueColumn, byteOrder);
            ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
            GenericIndexed<ImmutableBitmap> valueIndexes = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
            try (ColumnarInts throwAway = ints.get();){
                int size = throwAway.size();
                return new ScalarStringColumnAndIndexSupplier(stringDictionary, frontCodedStringDictionarySupplier, ints, valueIndexes, bitmapSerdeFactory, columnConfig, size);
            }
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to deserialize V%s column.", version);
        }
    }

    private ScalarStringColumnAndIndexSupplier(GenericIndexed<ByteBuffer> stringDictionary, Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier, Supplier<ColumnarInts> encodedColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapSerdeFactory serdeFactory, ColumnConfig columnConfig, int numRows) {
        this.stringDictionary = stringDictionary;
        this.frontCodedStringDictionarySupplier = frontCodedStringDictionarySupplier;
        this.encodedColumnSupplier = encodedColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.bitmapFactory = serdeFactory.getBitmapFactory();
        this.nullValueBitmap = valueIndexes.get(0) == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : valueIndexes.get(0);
        this.columnConfig = columnConfig;
        this.numRows = numRows;
    }

    public NestedCommonFormatColumn get() {
        if (this.frontCodedStringDictionarySupplier != null) {
            return new StringFrontCodedDictionaryEncodedColumn((ColumnarInts)this.encodedColumnSupplier.get(), null, (FrontCodedIndexed)this.frontCodedStringDictionarySupplier.get());
        }
        return new ScalarStringDictionaryEncodedColumn<GenericIndexed.BufferIndexed>((ColumnarInts)this.encodedColumnSupplier.get(), this.stringDictionary.singleThreaded());
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.valueIndexes != null) {
            Indexed<ByteBuffer> utf8Dictionary;
            GenericIndexed.BufferIndexed singleThreadedBitmaps = this.valueIndexes.singleThreaded();
            Indexed indexed = utf8Dictionary = this.frontCodedStringDictionarySupplier == null ? this.stringDictionary.singleThreaded() : (Indexed)this.frontCodedStringDictionarySupplier.get();
            if (clazz.equals(NullValueIndex.class)) {
                SimpleImmutableBitmapIndex nullIndex = new SimpleImmutableBitmapIndex(this.nullValueBitmap);
                return (T)((NullValueIndex)() -> nullIndex);
            }
            if (clazz.equals(StringValueSetIndex.class)) {
                return (T)new IndexedUtf8ValueSetIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, (GenericIndexed.BufferIndexed)utf8Dictionary, singleThreadedBitmaps);
            }
            if (clazz.equals(DruidPredicateIndex.class)) {
                return (T)new IndexedStringDruidPredicateIndex<StringEncodingStrategies.Utf8ToStringIndexed>(this.bitmapFactory, new StringEncodingStrategies.Utf8ToStringIndexed(utf8Dictionary), singleThreadedBitmaps, this.columnConfig, this.numRows);
            }
            if (clazz.equals(LexicographicalRangeIndex.class)) {
                return (T)new IndexedUtf8LexicographicalRangeIndex<Indexed<ByteBuffer>>(this.bitmapFactory, utf8Dictionary, singleThreadedBitmaps, utf8Dictionary.get(0) == null, this.columnConfig, this.numRows);
            }
            if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                return (T)new IndexedStringDictionaryEncodedStringValueIndex<StringEncodingStrategies.Utf8ToStringIndexed>(this.bitmapFactory, new StringEncodingStrategies.Utf8ToStringIndexed(utf8Dictionary), this.valueIndexes);
            }
        }
        return null;
    }
}

