/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ScalarStringColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(ScalarStringColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private DictionaryIdLookup dictionaryIdLookup;
    private DictionaryWriter<String> dictionaryWriter;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;
    private SingleValueColumnarIntsSerializer encodedValueSerializer;
    private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter;
    private MutableBitmap[] bitmaps;
    private ByteBuffer columnNameBytes = null;

    public ScalarStringColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.dictionaryIdLookup = new DictionaryIdLookup();
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getGlobalLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return !this.bitmaps[0].isEmpty();
    }

    @Override
    public void openDictionaryWriter() throws IOException {
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        CompressionStrategy compression = this.indexSpec.getDimensionCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, this.dictionaryWriter.getCardinality(), compressionToUse);
        this.encodedValueSerializer.open();
        this.bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapIndexWriter.open();
        this.bitmapIndexWriter.setObjectsNotSorted();
        this.bitmaps = new MutableBitmap[this.dictionaryWriter.getCardinality()];
        for (int i = 0; i < this.bitmaps.length; ++i) {
            this.bitmaps[i] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        this.dictionaryIdLookup.addString(null);
        for (String value : strings) {
            if ((value = NullHandling.emptyToNullIfNeeded(value)) == null) continue;
            this.dictionaryWriter.write(value);
            this.dictionaryIdLookup.addString(value);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        Object value = StructuredData.unwrap(selector.getObject());
        ExprEval eval = ExprEval.bestEffortOf(value);
        String s = eval.castTo(ExpressionType.STRING).asString();
        int dictId = this.dictionaryIdLookup.lookupString(s);
        this.encodedValueSerializer.addValue(dictId);
        this.bitmaps[dictId].add(this.rowCount);
        ++this.rowCount;
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            for (int i = 0; i < this.bitmaps.length; ++i) {
                MutableBitmap bitmap = this.bitmaps[i];
                this.bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
                this.bitmaps[i] = null;
            }
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        this.writeV0Header(channel, this.columnNameBytes);
        this.writeInternal(smoosher, this.dictionaryWriter, "__stringDictionary");
        this.writeInternal(smoosher, this.encodedValueSerializer, "__encodedColumn");
        this.writeInternal(smoosher, this.bitmapIndexWriter, "__valueIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

