/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.utils.CloseableUtils;

public class ScalarStringDictionaryEncodedColumn<TIndexed extends Indexed<ByteBuffer>>
implements DictionaryEncodedColumn<String>,
NestedCommonFormatColumn {
    private final ColumnarInts column;
    private final TIndexed utf8Dictionary;

    public ScalarStringDictionaryEncodedColumn(ColumnarInts singleValueColumn, TIndexed utf8Dictionary) {
        this.column = singleValueColumn;
        this.utf8Dictionary = utf8Dictionary;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        throw new UnsupportedOperationException("Column is not multi-valued");
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ByteBuffer buffer = (ByteBuffer)this.utf8Dictionary.get(id);
        if (buffer == null) {
            return null;
        }
        return StringUtils.fromUtf8(buffer);
    }

    @Override
    public int lookupId(String name) {
        return this.utf8Dictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer(name));
    }

    @Override
    public int getCardinality() {
        return this.utf8Dictionary.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        class SingleValueQueryableDimensionSelector
        extends AbstractDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup,
        HistoricalDimensionSelector {
            private final SingleIndexedInt row = new SingleIndexedInt();

            SingleValueQueryableDimensionSelector() {
            }

            @Override
            public int getValueCardinality() {
                return ScalarStringDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            public String lookupName(int id) {
                String value = ScalarStringDictionaryEncodedColumn.this.lookupName(id);
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)ScalarStringDictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public boolean supportsLookupNameUtf8() {
                return true;
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn != null) {
                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                }
                return ScalarStringDictionaryEncodedColumn.this.lookupId(name);
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return ScalarStringDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return ScalarStringDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", ScalarStringDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(ScalarStringDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(ScalarStringDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply((Object)this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", ScalarStringDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", ScalarStringDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringDictionaryEncodedColumn.StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(ScalarStringDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return ScalarStringDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return ScalarStringDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)ScalarStringDictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return ScalarStringDictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
        throw new UnsupportedOperationException("Column not multi-valued");
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringDictionaryEncodedColumn.StringVectorObjectSelector {
            public StringVectorSelector() {
                super(ScalarStringDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return ScalarStringDictionaryEncodedColumn.this.lookupName(id);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll(this.column, new Closeable[0]);
    }

    @Override
    public ColumnType getLogicalType() {
        return ColumnType.STRING;
    }

    @Override
    public Indexed<String> getStringDictionary() {
        return new StringEncodingStrategies.Utf8ToStringIndexed((Indexed<ByteBuffer>)this.utf8Dictionary);
    }
}

