/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class VariantColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final ColumnType logicalType;
    @Nullable
    private final Byte variantTypeSetByte;
    private final GenericIndexed<ByteBuffer> stringDictionary;
    private final Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final Supplier<ColumnarInts> encodedValueColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final ImmutableBitmap nullValueBitmap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VariantColumnAndIndexSupplier read(ColumnType logicalType, ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        Byte variantTypeByte = bb.hasRemaining() ? Byte.valueOf(bb.get()) : null;
        if (version != 0) throw new RE("Unknown version " + version, new Object[0]);
        try {
            GenericIndexed<ByteBuffer> stringDictionary;
            Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
            SmooshedFileMapper mapper = columnBuilder.getFileMapper();
            ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__stringDictionary");
            int dictionaryStartPosition = stringDictionaryBuffer.position();
            byte dictionaryVersion = stringDictionaryBuffer.get();
            if (dictionaryVersion == 127) {
                byte encodingId = stringDictionaryBuffer.get();
                if (encodingId == 1) {
                    frontCodedStringDictionarySupplier = FrontCodedIndexed.read(stringDictionaryBuffer, byteOrder);
                    stringDictionary = null;
                } else {
                    if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", encodingId);
                    stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                    frontCodedStringDictionarySupplier = null;
                }
            } else {
                stringDictionaryBuffer.position(dictionaryStartPosition);
                stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                frontCodedStringDictionarySupplier = null;
            }
            ByteBuffer encodedValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__encodedColumn");
            CompressedVSizeColumnarIntsSupplier ints = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(encodedValueColumn, byteOrder);
            ByteBuffer longDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__longDictionary");
            ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleDictionary");
            ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
            GenericIndexed<ImmutableBitmap> valueIndexes = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
            Supplier longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), byteOrder, 8);
            Supplier doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
            ByteBuffer arrayDictionarybuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__arrayDictionary");
            Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, byteOrder);
            try (ColumnarInts throwAway = ints.get();){
                int size = throwAway.size();
                return new VariantColumnAndIndexSupplier(logicalType, variantTypeByte, stringDictionary, frontCodedStringDictionarySupplier, longDictionarySupplier, doubleDictionarySupplier, arrayDictionarySupplier, ints, valueIndexes, bitmapSerdeFactory.getBitmapFactory(), columnConfig, size);
            }
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to deserialize V%s column.", version);
        }
    }

    public VariantColumnAndIndexSupplier(ColumnType logicalType, @Nullable Byte variantTypeSetByte, GenericIndexed<ByteBuffer> stringDictionary, Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, Supplier<ColumnarInts> encodedValueColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapFactory bitmapFactory, ColumnConfig columnConfig, int numRows) {
        this.logicalType = logicalType;
        this.variantTypeSetByte = variantTypeSetByte;
        this.stringDictionary = stringDictionary;
        this.frontCodedStringDictionarySupplier = frontCodedStringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.encodedValueColumnSupplier = encodedValueColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.nullValueBitmap = valueIndexes.get(0) == null ? bitmapFactory.makeEmptyImmutableBitmap() : valueIndexes.get(0);
    }

    public NestedCommonFormatColumn get() {
        if (this.frontCodedStringDictionarySupplier != null) {
            return new VariantColumn<Indexed>((Indexed)this.frontCodedStringDictionarySupplier.get(), (FixedIndexed)this.longDictionarySupplier.get(), (FixedIndexed)this.doubleDictionarySupplier.get(), (FrontCodedIntArrayIndexed)this.arrayDictionarySupplier.get(), (ColumnarInts)this.encodedValueColumnSupplier.get(), this.nullValueBitmap, this.logicalType, this.variantTypeSetByte);
        }
        return new VariantColumn<GenericIndexed.BufferIndexed>(this.stringDictionary.singleThreaded(), (FixedIndexed)this.longDictionarySupplier.get(), (FixedIndexed)this.doubleDictionarySupplier.get(), (FrontCodedIntArrayIndexed)this.arrayDictionarySupplier.get(), (ColumnarInts)this.encodedValueColumnSupplier.get(), this.nullValueBitmap, this.logicalType, this.variantTypeSetByte);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = new SimpleImmutableBitmapIndex(this.nullValueBitmap);
            return (T)((NullValueIndex)() -> nullIndex);
        }
        return null;
    }
}

