/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class VariantColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(VariantColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private DictionaryIdLookup dictionaryIdLookup;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private FrontCodedIntArrayIndexedWriter arrayDictionaryWriter;
    private FixedIndexedIntWriter arrayElementDictionaryWriter;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;
    private SingleValueColumnarIntsSerializer encodedValueSerializer;
    private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter;
    private GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter;
    private MutableBitmap[] bitmaps;
    private ByteBuffer columnNameBytes = null;
    private final Int2ObjectRBTreeMap<MutableBitmap> arrayElements = new Int2ObjectRBTreeMap();
    @Nullable
    private final Byte variantTypeSetByte;

    public VariantColumnSerializer(String name, @Nullable Byte variantTypeSetByte, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.variantTypeSetByte = variantTypeSetByte;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.dictionaryIdLookup = new DictionaryIdLookup();
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getGlobalLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return !this.bitmaps[0].isEmpty();
    }

    @Override
    public void openDictionaryWriter() throws IOException {
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.arrayDictionaryWriter = new FrontCodedIntArrayIndexedWriter(this.segmentWriteOutMedium, ByteOrder.nativeOrder(), 4);
        this.arrayDictionaryWriter.open();
        this.arrayElementDictionaryWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, true);
        this.arrayElementDictionaryWriter.open();
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        int cardinality = this.dictionaryWriter.getCardinality() + this.longDictionaryWriter.getCardinality() + this.doubleDictionaryWriter.getCardinality() + this.arrayDictionaryWriter.getCardinality();
        CompressionStrategy compression = this.indexSpec.getDimensionCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, cardinality, compressionToUse);
        this.encodedValueSerializer.open();
        this.bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapIndexWriter.open();
        this.bitmapIndexWriter.setObjectsNotSorted();
        this.bitmaps = new MutableBitmap[cardinality];
        for (int i = 0; i < this.bitmaps.length; ++i) {
            this.bitmaps[i] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
        this.arrayElementIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name + "_arrays", this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.arrayElementIndexWriter.open();
        this.arrayElementIndexWriter.setObjectsNotSorted();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        this.dictionaryIdLookup.addString(null);
        for (String string : strings) {
            String string2 = NullHandling.emptyToNullIfNeeded(string);
            if (string2 == null) continue;
            this.dictionaryWriter.write(string2);
            this.dictionaryIdLookup.addString(string2);
        }
        for (Long l : longs) {
            if (l == null) continue;
            this.longDictionaryWriter.write(l);
            this.dictionaryIdLookup.addLong(l);
        }
        for (Double d : doubles) {
            if (d == null) continue;
            this.doubleDictionaryWriter.write(d);
            this.dictionaryIdLookup.addDouble(d);
        }
        for (int[] nArray : arrays) {
            if (nArray == null) continue;
            this.arrayDictionaryWriter.write(nArray);
            this.dictionaryIdLookup.addArray(nArray);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        ExprEval eval = ExprEval.bestEffortOf(StructuredData.unwrap(selector.getObject()));
        if (eval.isArray()) {
            Object[] array = eval.asArray();
            int[] globalIds = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? this.dictionaryIdLookup.lookupString((String)array[i]) : (array[i] instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)array[i]) : (array[i] instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)array[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (Object[])new Object[]{globalIds[i], array[i]});
                ((MutableBitmap)this.arrayElements.computeIfAbsent(globalIds[i], id -> this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap())).add(this.rowCount);
            }
            int dictId = this.dictionaryIdLookup.lookupArray(globalIds);
            this.encodedValueSerializer.addValue(dictId);
            this.bitmaps[dictId].add(this.rowCount);
        } else {
            Object o = eval.value();
            int dictId = o == null ? 0 : (o instanceof String ? this.dictionaryIdLookup.lookupString((String)o) : (o instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)o) : (o instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)o) : -1)));
            Preconditions.checkArgument((dictId >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (Object[])new Object[]{dictId, o});
            if (dictId != 0) {
                ((MutableBitmap)this.arrayElements.computeIfAbsent(dictId, id -> this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap())).add(this.rowCount);
            }
            this.encodedValueSerializer.addValue(dictId);
            this.bitmaps[dictId].add(this.rowCount);
        }
        ++this.rowCount;
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            for (int i = 0; i < this.bitmaps.length; ++i) {
                MutableBitmap bitmap = this.bitmaps[i];
                this.bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
                this.bitmaps[i] = null;
            }
            for (Int2ObjectMap.Entry arrayElement : this.arrayElements.int2ObjectEntrySet()) {
                this.arrayElementDictionaryWriter.write(arrayElement.getIntKey());
                this.arrayElementIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap((MutableBitmap)arrayElement.getValue()));
            }
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        if (this.variantTypeSetByte != null) {
            ++size;
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        this.writeV0Header(channel, this.columnNameBytes);
        if (this.variantTypeSetByte != null) {
            channel.write(ByteBuffer.wrap(new byte[]{this.variantTypeSetByte}));
        }
        this.writeInternal(smoosher, this.dictionaryWriter, "__stringDictionary");
        this.writeInternal(smoosher, this.longDictionaryWriter, "__longDictionary");
        this.writeInternal(smoosher, this.doubleDictionaryWriter, "__doubleDictionary");
        this.writeInternal(smoosher, this.arrayDictionaryWriter, "__arrayDictionary");
        this.writeInternal(smoosher, this.arrayElementDictionaryWriter, "__arrayElementDictionary");
        this.writeInternal(smoosher, this.encodedValueSerializer, "__encodedColumn");
        this.writeInternal(smoosher, this.bitmapIndexWriter, "__valueIndexes");
        this.writeInternal(smoosher, this.arrayElementIndexWriter, "__arrayElementIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

