/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.IndexedStringDictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.IndexedStringDruidPredicateIndex;
import org.apache.druid.segment.column.IndexedUtf8LexicographicalRangeIndex;
import org.apache.druid.segment.column.IndexedUtf8ValueSetIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.Utf8ValueSetIndex;
import org.apache.druid.segment.data.GenericIndexed;

public class DictionaryEncodedStringIndexSupplier
implements ColumnIndexSupplier {
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<String> dictionary;
    private final GenericIndexed<ByteBuffer> dictionaryUtf8;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    @Nullable
    private final ImmutableRTree indexedTree;

    public DictionaryEncodedStringIndexSupplier(BitmapFactory bitmapFactory, GenericIndexed<String> dictionary, GenericIndexed<ByteBuffer> dictionaryUtf8, @Nullable GenericIndexed<ImmutableBitmap> bitmaps, @Nullable ImmutableRTree indexedTree) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.dictionaryUtf8 = dictionaryUtf8;
        this.bitmaps = bitmaps;
        this.indexedTree = indexedTree;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.bitmaps != null) {
            GenericIndexed.BufferIndexed singleThreadedStrings = this.dictionary.singleThreaded();
            GenericIndexed.BufferIndexed singleThreadedUtf8 = this.dictionaryUtf8.singleThreaded();
            GenericIndexed.BufferIndexed singleThreadedBitmaps = this.bitmaps.singleThreaded();
            if (clazz.equals(NullValueIndex.class)) {
                SimpleImmutableBitmapIndex nullIndex = NullHandling.isNullOrEquivalent(this.dictionary.get(0)) ? new SimpleImmutableBitmapIndex(this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
                return (T)((NullValueIndex)() -> nullIndex);
            }
            if (clazz.equals(StringValueSetIndex.class)) {
                return (T)new IndexedUtf8ValueSetIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, singleThreadedUtf8, singleThreadedBitmaps);
            }
            if (clazz.equals(Utf8ValueSetIndex.class)) {
                return (T)new IndexedUtf8ValueSetIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, singleThreadedUtf8, singleThreadedBitmaps);
            }
            if (clazz.equals(DruidPredicateIndex.class)) {
                return (T)new IndexedStringDruidPredicateIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, singleThreadedStrings, singleThreadedBitmaps);
            }
            if (clazz.equals(LexicographicalRangeIndex.class)) {
                return (T)new IndexedUtf8LexicographicalRangeIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, singleThreadedUtf8, singleThreadedBitmaps, NullHandling.isNullOrEquivalent(this.dictionary.get(0)));
            }
            if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                return (T)new IndexedStringDictionaryEncodedStringValueIndex<GenericIndexed.BufferIndexed>(this.bitmapFactory, singleThreadedStrings, this.bitmaps);
            }
        }
        if (this.indexedTree != null && clazz.equals(SpatialIndex.class)) {
            return (T)((SpatialIndex)() -> this.indexedTree);
        }
        return null;
    }
}

