/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnSupplier;
import org.apache.druid.segment.nested.ScalarDoubleColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarLongColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarStringColumnAndIndexSupplier;
import org.apache.druid.segment.nested.VariantColumnAndIndexSupplier;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;

public class NestedCommonFormatColumnPartSerde
implements ColumnPartSerde {
    private final ColumnType logicalType;
    private final boolean hasNulls;
    private final boolean isVariantType;
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    @Nullable
    private final Serializer serializer;

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, String fileNameBase, String internalFileName) throws IOException {
        return fileMapper.mapFile(NestedCommonFormatColumnSerializer.getInternalFileName(fileNameBase, internalFileName));
    }

    @JsonCreator
    public static NestedCommonFormatColumnPartSerde createDeserializer(@JsonProperty(value="logicalType") ColumnType logicalType, @JsonProperty(value="hasNulls") boolean hasNulls, @JsonProperty(value="isVariantType") boolean isVariantType, @JsonProperty(value="byteOrder") ByteOrder byteOrder, @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        return new NestedCommonFormatColumnPartSerde(logicalType, hasNulls, isVariantType, byteOrder, bitmapSerdeFactory, null);
    }

    private NestedCommonFormatColumnPartSerde(ColumnType logicalType, boolean hasNulls, boolean isVariant, ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.logicalType = logicalType;
        this.hasNulls = hasNulls;
        this.isVariantType = isVariant;
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        if (this.isVariantType || this.logicalType.isArray()) {
            return (buffer, builder, columnConfig) -> {
                VariantColumnAndIndexSupplier supplier = VariantColumnAndIndexSupplier.read(this.logicalType, this.byteOrder, this.bitmapSerdeFactory, buffer, builder, columnConfig);
                ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
                capabilitiesBuilder.setDictionaryEncoded(true);
                capabilitiesBuilder.setDictionaryValuesSorted(true);
                capabilitiesBuilder.setDictionaryValuesUnique(true);
                builder.setType(this.logicalType);
                builder.setNestedCommonFormatColumnSupplier(supplier);
                builder.setColumnFormat(new NestedCommonFormatColumn.Format(this.logicalType, capabilitiesBuilder.hasNulls().isTrue()));
                builder.setFilterable(true);
            };
        }
        if (this.logicalType.is(ValueType.STRING)) {
            return (buffer, builder, columnConfig) -> {
                ScalarStringColumnAndIndexSupplier supplier = ScalarStringColumnAndIndexSupplier.read(this.byteOrder, this.bitmapSerdeFactory, buffer, builder, columnConfig);
                ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
                capabilitiesBuilder.setDictionaryEncoded(true);
                capabilitiesBuilder.setDictionaryValuesSorted(true);
                capabilitiesBuilder.setDictionaryValuesUnique(true);
                builder.setType(this.logicalType);
                builder.setNestedCommonFormatColumnSupplier(supplier);
                builder.setIndexSupplier(supplier, true, false);
                builder.setColumnFormat(new NestedCommonFormatColumn.Format(this.logicalType, capabilitiesBuilder.hasNulls().isTrue()));
                builder.setFilterable(true);
            };
        }
        if (this.logicalType.is(ValueType.LONG)) {
            return (buffer, builder, columnConfig) -> {
                ScalarLongColumnAndIndexSupplier supplier = ScalarLongColumnAndIndexSupplier.read(this.byteOrder, this.bitmapSerdeFactory, buffer, builder, columnConfig);
                ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
                capabilitiesBuilder.setDictionaryEncoded(true);
                capabilitiesBuilder.setDictionaryValuesSorted(true);
                capabilitiesBuilder.setDictionaryValuesUnique(true);
                builder.setType(this.logicalType);
                builder.setNestedCommonFormatColumnSupplier(supplier);
                builder.setIndexSupplier(supplier, true, false);
                builder.setColumnFormat(new NestedCommonFormatColumn.Format(this.logicalType, capabilitiesBuilder.hasNulls().isTrue()));
                builder.setFilterable(true);
            };
        }
        if (this.logicalType.is(ValueType.DOUBLE)) {
            return (buffer, builder, columnConfig) -> {
                ScalarDoubleColumnAndIndexSupplier supplier = ScalarDoubleColumnAndIndexSupplier.read(this.byteOrder, this.bitmapSerdeFactory, buffer, builder, columnConfig);
                ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
                capabilitiesBuilder.setDictionaryEncoded(true);
                capabilitiesBuilder.setDictionaryValuesSorted(true);
                capabilitiesBuilder.setDictionaryValuesUnique(true);
                builder.setType(this.logicalType);
                builder.setNestedCommonFormatColumnSupplier(supplier);
                builder.setIndexSupplier(supplier, true, false);
                builder.setColumnFormat(new NestedCommonFormatColumn.Format(this.logicalType, capabilitiesBuilder.hasNulls().isTrue()));
                builder.setFilterable(true);
            };
        }
        return (buffer, builder, columnConfig) -> {
            NestedDataColumnSupplier supplier = NestedDataColumnSupplier.read(this.hasNulls, buffer, builder, columnConfig, this.bitmapSerdeFactory, this.byteOrder);
            ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
            capabilitiesBuilder.setDictionaryEncoded(true);
            capabilitiesBuilder.setDictionaryValuesSorted(true);
            capabilitiesBuilder.setDictionaryValuesUnique(true);
            ColumnType simpleType = supplier.getLogicalType();
            ColumnType logicalType = simpleType == null ? ColumnType.NESTED_DATA : simpleType;
            builder.setType(logicalType);
            builder.setNestedCommonFormatColumnSupplier(supplier);
            builder.setColumnFormat(new NestedCommonFormatColumn.Format(logicalType, this.hasNulls));
            builder.setFilterable(true);
        };
    }

    @JsonProperty
    public ColumnType getLogicalType() {
        return this.logicalType;
    }

    @JsonProperty
    public boolean isHasNulls() {
        return this.hasNulls;
    }

    @JsonProperty(value="isVariantType")
    public boolean isVariantType() {
        return this.isVariantType;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static class SerializerBuilder {
        private ColumnType logicalType;
        private boolean hasNulls;
        private boolean isVariantType;
        private ByteOrder byteOrder = ByteOrder.nativeOrder();
        BitmapSerdeFactory bitmapSerdeFactory;
        @Nullable
        private Serializer serializer = null;

        public SerializerBuilder withLogicalType(ColumnType logicalType) {
            this.logicalType = logicalType;
            return this;
        }

        public SerializerBuilder isVariantType(boolean isVariant) {
            this.isVariantType = isVariant;
            return this;
        }

        public SerializerBuilder withSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory serdeFactory) {
            this.bitmapSerdeFactory = serdeFactory;
            return this;
        }

        public SerializerBuilder withHasNulls(boolean hasNulls) {
            this.hasNulls = hasNulls;
            return this;
        }

        public NestedCommonFormatColumnPartSerde build() {
            return new NestedCommonFormatColumnPartSerde(this.logicalType, this.hasNulls, this.isVariantType, this.byteOrder, this.bitmapSerdeFactory, this.serializer);
        }
    }
}

