/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.IndexedStringDictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.IndexedStringDruidPredicateIndex;
import org.apache.druid.segment.column.IndexedUtf8LexicographicalRangeIndex;
import org.apache.druid.segment.column.IndexedUtf8ValueSetIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;

public class StringFrontCodedColumnIndexSupplier
implements ColumnIndexSupplier {
    private final BitmapFactory bitmapFactory;
    private final Supplier<StringEncodingStrategies.Utf8ToStringIndexed> dictionary;
    private final Supplier<FrontCodedIndexed> utf8Dictionary;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    @Nullable
    private final ImmutableRTree indexedTree;

    public StringFrontCodedColumnIndexSupplier(BitmapFactory bitmapFactory, Supplier<FrontCodedIndexed> utf8Dictionary, @Nullable GenericIndexed<ImmutableBitmap> bitmaps, @Nullable ImmutableRTree indexedTree) {
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.utf8Dictionary = utf8Dictionary;
        this.dictionary = () -> new StringEncodingStrategies.Utf8ToStringIndexed((Indexed)this.utf8Dictionary.get());
        this.indexedTree = indexedTree;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.bitmaps != null) {
            GenericIndexed.BufferIndexed singleThreadedBitmaps = this.bitmaps.singleThreaded();
            if (clazz.equals(NullValueIndex.class)) {
                StringEncodingStrategies.Utf8ToStringIndexed stringDictionary = (StringEncodingStrategies.Utf8ToStringIndexed)this.dictionary.get();
                SimpleImmutableBitmapIndex nullIndex = NullHandling.isNullOrEquivalent(stringDictionary.get(0)) ? new SimpleImmutableBitmapIndex(this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
                return (T)((NullValueIndex)() -> nullIndex);
            }
            if (clazz.equals(StringValueSetIndex.class)) {
                return (T)new IndexedUtf8ValueSetIndex<Indexed>(this.bitmapFactory, (Indexed)this.utf8Dictionary.get(), singleThreadedBitmaps);
            }
            if (clazz.equals(DruidPredicateIndex.class)) {
                return (T)new IndexedStringDruidPredicateIndex<Indexed>(this.bitmapFactory, (Indexed)this.dictionary.get(), singleThreadedBitmaps);
            }
            if (clazz.equals(LexicographicalRangeIndex.class)) {
                FrontCodedIndexed dict;
                return (T)new IndexedUtf8LexicographicalRangeIndex<FrontCodedIndexed>(this.bitmapFactory, dict, singleThreadedBitmaps, (dict = (FrontCodedIndexed)this.utf8Dictionary.get()).get(0) == null);
            }
            if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                return (T)new IndexedStringDictionaryEncodedStringValueIndex<Indexed>(this.bitmapFactory, (Indexed)this.dictionary.get(), this.bitmaps);
            }
        }
        if (this.indexedTree != null && clazz.equals(SpatialIndex.class)) {
            return (T)((SpatialIndex)() -> this.indexedTree);
        }
        return null;
    }
}

