/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.virtual.SingleInputBindings;

public class SingleStringInputDeferredEvaluationExpressionDimensionSelector
implements DimensionSelector {
    private final DimensionSelector selector;
    private final Expr expression;
    private final SingleInputBindings bindings = new SingleInputBindings(ExpressionType.STRING);

    public SingleStringInputDeferredEvaluationExpressionDimensionSelector(DimensionSelector selector, Expr expression) {
        if (selector.getValueCardinality() == -1 || !selector.nameLookupPossibleInAdvance()) {
            throw new ISE("Selector of class[%s] does not have a dictionary, cannot use it.", selector.getClass().getName());
        }
        this.selector = (DimensionSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
        this.expression = (Expr)Preconditions.checkNotNull((Object)expression, (Object)"expression");
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public IndexedInts getRow() {
        return this.selector.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    @Override
    public int getValueCardinality() {
        return this.selector.getValueCardinality();
    }

    @Override
    public String lookupName(int id) {
        String value = this.selector.lookupName(id);
        this.bindings.set(value);
        return this.expression.eval(this.bindings).asString();
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }
}

