/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.druid.utils.RuntimeInfo;

public class JvmUtils {
    public static final int UNKNOWN_VERSION = -1;
    private static final int MAJOR_VERSION = JvmUtils.computeMajorVersion();
    @Inject
    private static RuntimeInfo RUNTIME_INFO = new RuntimeInfo();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    private static int computeMajorVersion() {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.specification.version"), ".");
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String majorVersionString = st.nextToken();
        Integer majorVersion = Ints.tryParse((String)majorVersionString);
        return majorVersion == null ? -1 : majorVersion;
    }

    public static int majorVersion() {
        return MAJOR_VERSION;
    }

    public static boolean isIsJava9Compatible() {
        return MAJOR_VERSION >= 9;
    }

    public static RuntimeInfo getRuntimeInfo() {
        return RUNTIME_INFO;
    }

    public static boolean isThreadCpuTimeEnabled() {
        return THREAD_MX_BEAN.isThreadCpuTimeSupported() && THREAD_MX_BEAN.isThreadCpuTimeEnabled();
    }

    public static long safeGetThreadCpuTime() {
        if (!JvmUtils.isThreadCpuTimeEnabled()) {
            return 0L;
        }
        return JvmUtils.getCurrentThreadCpuTime();
    }

    public static long getCurrentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T safeAccumulateThreadCpuTime(AtomicLong accumulator, Supplier<T> function) {
        long start = JvmUtils.safeGetThreadCpuTime();
        try {
            T t = function.get();
            return t;
        }
        finally {
            accumulator.addAndGet(JvmUtils.safeGetThreadCpuTime() - start);
        }
    }

    public static List<URL> systemClassPath() {
        String[] paths = System.getProperty("java.class.path").split(File.pathSeparator);
        List<URL> jobURLs = Stream.of(paths).map(s -> {
            try {
                return Paths.get(s, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new UnsupportedOperationException("Unable to create URL classpath entry", e);
            }
        }).collect(Collectors.toList());
        return jobURLs;
    }

    public static void resetTestsToDefaultRuntimeInfo() {
        RUNTIME_INFO = new RuntimeInfo();
    }
}

