/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;

public class FastLineIterator
implements CloseableIterator<String> {
    static final int BUFFER_SIZE = 512;
    private static final ThreadLocal<byte[]> BUFFER_LOCAL = ThreadLocal.withInitial(() -> new byte[512]);
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream source;
    private final ByteArrayList buffer;
    private String nextLine;

    public FastLineIterator(InputStream source) {
        this(source, new ByteArrayList());
    }

    public FastLineIterator(InputStream source, ByteArrayList buffer) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)buffer);
        this.source = source;
        this.nextLine = null;
        this.buffer = buffer;
        this.buffer.size(0);
    }

    @Override
    public void close() throws IOException {
        this.nextLine = null;
        this.source.close();
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        this.readNextLine();
        return this.nextLine != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more lines");
        }
        String result = this.nextLine;
        this.nextLine = null;
        return result;
    }

    void readNextLine() {
        byte[] load = BUFFER_LOCAL.get();
        boolean endOfFile = false;
        int indexOfLf = this.buffer.indexOf((byte)10);
        block2: while (!endOfFile && indexOfLf < 0) {
            int readCount;
            try {
                readCount = this.source.read(load);
            }
            catch (IOException e) {
                this.nextLine = null;
                throw new IllegalStateException(e);
            }
            if (readCount < 0) {
                endOfFile = true;
                continue;
            }
            int sizeBefore = this.buffer.size();
            this.buffer.addElements(this.buffer.size(), load, 0, readCount);
            for (int i = 0; i < readCount; ++i) {
                if (load[i] != 10) continue;
                indexOfLf = sizeBefore + i;
                continue block2;
            }
        }
        if (endOfFile && this.buffer.size() == 0) {
            this.nextLine = null;
        } else if (indexOfLf < 0) {
            this.nextLine = StringUtils.fromUtf8(this.buffer);
            this.buffer.removeElements(0, this.buffer.size());
        } else if (indexOfLf >= 1 && this.buffer.getByte(indexOfLf - 1) == 13) {
            this.nextLine = StringUtils.fromUtf8(this.buffer.elements(), 0, indexOfLf - 1);
            this.buffer.removeElements(0, indexOfLf + 1);
        } else {
            this.nextLine = StringUtils.fromUtf8(this.buffer.elements(), 0, indexOfLf);
            this.buffer.removeElements(0, indexOfLf + 1);
        }
    }
}

