/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.QueryExceptionCompat;
import org.apache.druid.query.QueryException;

public class ErrorResponse {
    private final DruidException underlyingException;

    @JsonCreator
    public static ErrorResponse fromMap(final Map<String, Object> map) {
        Object legacyErrorType = map.get("error");
        DruidException.Failure failure = !"druidException".equals(legacyErrorType) ? new QueryExceptionCompat(new QueryException(ErrorResponse.nullOrString(map.get("error")), ErrorResponse.nullOrString(map.get("errorMessage")), ErrorResponse.nullOrString(map.get("errorClass")), ErrorResponse.nullOrString(map.get("host")))) : new DruidException.Failure(ErrorResponse.stringOrFailure(map, "errorCode")){

            @Override
            protected DruidException makeException(DruidException.DruidExceptionBuilder bob) {
                DruidException retVal = bob.forPersona(DruidException.Persona.valueOf(ErrorResponse.stringOrFailure(map, "persona"))).ofCategory(DruidException.Category.valueOf(ErrorResponse.stringOrFailure(map, "category"))).build(ErrorResponse.stringOrFailure(map, "errorMessage"), new Object[0]);
                Object context = map.get("context");
                if (context instanceof Map) {
                    retVal.withContext((Map)context);
                }
                return retVal;
            }
        };
        return new ErrorResponse(DruidException.fromFailure(new DeserializedFailure(failure)));
    }

    public ErrorResponse(DruidException underlyingException) {
        this.underlyingException = underlyingException;
    }

    @JsonValue
    public Map<String, Object> getAsMap() {
        LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
        if ("legacyQueryException".equals(this.underlyingException.getErrorCode())) {
            retVal.put("error", this.underlyingException.getContextValue("legacyErrorCode"));
            retVal.put("errorClass", this.underlyingException.getContextValue("errorClass"));
            retVal.put("host", this.underlyingException.getContextValue("host"));
        } else {
            retVal.put("error", "druidException");
        }
        retVal.put("errorCode", this.underlyingException.getErrorCode());
        retVal.put("persona", this.underlyingException.getTargetPersona().toString());
        retVal.put("category", this.underlyingException.getCategory().toString());
        retVal.put("errorMessage", this.underlyingException.getMessage());
        retVal.put("context", this.underlyingException.getContext());
        return retVal;
    }

    public DruidException getUnderlyingException() {
        return this.underlyingException;
    }

    @Nullable
    private static String nullOrString(Object o) {
        return o == null ? null : o.toString();
    }

    private static String stringOrFailure(Map<String, Object> map, String key) {
        Object o = map.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        DruidException problem = DruidException.forPersona(DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("Got an error response that had a non-String value [%s] for key [%s]", o, key);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            problem.withContext(entry.getKey(), value.toString());
        }
        throw problem;
    }

    private static class DeserializedFailure
    extends DruidException.Failure {
        private final DruidException.Failure delegate;

        public DeserializedFailure(DruidException.Failure delegate) {
            super(delegate.getErrorCode());
            this.delegate = delegate;
        }

        @Override
        protected DruidException makeException(DruidException.DruidExceptionBuilder bob) {
            bob.wasDeserialized();
            final DruidException cause = this.delegate.makeException(bob);
            return DruidException.fromFailure(new DruidException.Failure(cause.getErrorCode()){

                @Override
                protected DruidException makeException(DruidException.DruidExceptionBuilder bob) {
                    return bob.forPersona(cause.getTargetPersona()).ofCategory(cause.getCategory()).build(cause, cause.getMessage(), new Object[0]).withContext(cause.getContext());
                }
            });
        }
    }
}

