/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import org.apache.druid.error.DruidException;
import org.apache.druid.query.QueryException;

public class QueryExceptionCompat
extends DruidException.Failure {
    public static final String ERROR_CODE = "legacyQueryException";
    private final QueryException exception;

    public QueryExceptionCompat(QueryException exception) {
        super(ERROR_CODE);
        this.exception = exception;
    }

    @Override
    protected DruidException makeException(DruidException.DruidExceptionBuilder bob) {
        return bob.forPersona(DruidException.Persona.OPERATOR).ofCategory(this.convertFailType(this.exception.getFailType())).build(this.exception.getMessage(), new Object[0]).withContext("host", this.exception.getHost()).withContext("errorClass", this.exception.getErrorClass()).withContext("legacyErrorCode", this.exception.getErrorCode());
    }

    private DruidException.Category convertFailType(QueryException.FailType failType) {
        switch (failType) {
            case USER_ERROR: {
                return DruidException.Category.INVALID_INPUT;
            }
            case UNAUTHORIZED: {
                return DruidException.Category.UNAUTHORIZED;
            }
            case CAPACITY_EXCEEDED: {
                return DruidException.Category.CAPACITY_EXCEEDED;
            }
            case QUERY_RUNTIME_FAILURE: {
                return DruidException.Category.RUNTIME_FAILURE;
            }
            case CANCELED: {
                return DruidException.Category.CANCELED;
            }
            case UNSUPPORTED: {
                return DruidException.Category.UNSUPPORTED;
            }
            case TIMEOUT: {
                return DruidException.Category.TIMEOUT;
            }
        }
        return DruidException.Category.UNCATEGORIZED;
    }
}

