/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.LongFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;

public class LongFieldReader
implements FieldReader {
    LongFieldReader() {
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        return ValueTypes.makeNumericWrappingDimensionSelector(ValueType.LONG, this.makeColumnValueSelector(memory, fieldPointer), extractionFn);
    }

    @Override
    public boolean isNull(Memory memory, long position) {
        return memory.getByte(position) == 0;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    private static class Selector
    implements LongColumnSelector {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;

        private Selector(Memory memory, ReadableFieldPointer fieldPointer) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
        }

        @Override
        public long getLong() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            long bits = this.memory.getLong(this.fieldPointer.position() + 1L);
            return LongFieldWriter.detransform(bits);
        }

        @Override
        public boolean isNull() {
            return this.memory.getByte(this.fieldPointer.position()) == 0;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

