/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.java.util.common.IAE;

public class ByteRowKeyComparator
implements Comparator<byte[]> {
    private final int firstFieldPosition;
    private final int[] ascDescRunLengths;

    private ByteRowKeyComparator(int firstFieldPosition, int[] ascDescRunLengths) {
        this.firstFieldPosition = firstFieldPosition;
        this.ascDescRunLengths = ascDescRunLengths;
    }

    public static ByteRowKeyComparator create(List<KeyColumn> keyColumns) {
        return new ByteRowKeyComparator(ByteRowKeyComparator.computeFirstFieldPosition(keyColumns.size()), ByteRowKeyComparator.computeAscDescRunLengths(keyColumns));
    }

    public static int computeFirstFieldPosition(int fieldCount) {
        return Ints.checkedCast((long)((long)fieldCount * 4L));
    }

    public static int[] computeAscDescRunLengths(List<KeyColumn> keyColumns) {
        IntArrayList ascDescRunLengths = new IntArrayList(4);
        KeyOrder order = KeyOrder.ASCENDING;
        int runLength = 0;
        for (KeyColumn column : keyColumns) {
            if (column.order() == KeyOrder.NONE) {
                throw new IAE("Key must be sortable", new Object[0]);
            }
            if (column.order() != order) {
                ascDescRunLengths.add(runLength);
                runLength = 0;
                order = order == KeyOrder.ASCENDING ? KeyOrder.DESCENDING : KeyOrder.ASCENDING;
            }
            ++runLength;
        }
        if (runLength > 0) {
            ascDescRunLengths.add(runLength);
        }
        return ascDescRunLengths.toIntArray();
    }

    @Override
    public int compare(byte[] keyArray1, byte[] keyArray2) {
        int comparableBytesStartPosition1 = this.firstFieldPosition;
        int comparableBytesStartPosition2 = this.firstFieldPosition;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int comparableBytesEndPosition2;
                int nextField = field + numFields;
                int comparableBytesEndPosition1 = RowKeyReader.fieldEndPosition(keyArray1, nextField - 1);
                int cmp = FrameReaderUtils.compareByteArraysUnsigned(keyArray1, comparableBytesStartPosition1, comparableBytesEndPosition1 - comparableBytesStartPosition1, keyArray2, comparableBytesStartPosition2, (comparableBytesEndPosition2 = RowKeyReader.fieldEndPosition(keyArray2, nextField - 1)) - comparableBytesStartPosition2);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field = nextField;
                comparableBytesStartPosition1 = comparableBytesEndPosition1;
                comparableBytesStartPosition2 = comparableBytesEndPosition2;
            }
            ascending = !ascending;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteRowKeyComparator that = (ByteRowKeyComparator)o;
        return this.firstFieldPosition == that.firstFieldPosition && Arrays.equals(this.ascDescRunLengths, that.ascDescRunLengths);
    }

    public int hashCode() {
        int result = Objects.hash(this.firstFieldPosition);
        result = 31 * result + Arrays.hashCode(this.ascDescRunLengths);
        return result;
    }

    public String toString() {
        return "ByteRowKeyComparator{firstFieldPosition=" + this.firstFieldPosition + ", ascDescRunLengths=" + Arrays.toString(this.ascDescRunLengths) + '}';
    }
}

