/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.SimpleSettableOffset;
import org.joda.time.DateTime;

public class FrameCursor
implements Cursor {
    private final SimpleSettableOffset offset;
    private final ColumnSelectorFactory columnSelectorFactory;

    public FrameCursor(SimpleSettableOffset offset, ColumnSelectorFactory columnSelectorFactory) {
        this.offset = offset;
        this.columnSelectorFactory = columnSelectorFactory;
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Override
    public DateTime getTime() {
        return DateTimes.MIN;
    }

    @Override
    public void advance() {
        this.offset.increment();
        BaseQuery.checkInterrupted();
    }

    @Override
    public void advanceUninterruptibly() {
        this.offset.increment();
    }

    @Override
    public boolean isDone() {
        return !this.offset.withinBounds();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.isDone() || Thread.currentThread().isInterrupted();
    }

    @Override
    public void reset() {
        this.offset.reset();
    }

    public int getCurrentRow() {
        return this.offset.getOffset();
    }

    public void setCurrentRow(int rowNumber) {
        this.offset.setCurrentOffset(rowNumber);
    }
}

