/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class InvalidNullByteException
extends RuntimeException {
    @Nullable
    private final String source;
    @Nullable
    private final Integer rowNumber;
    @Nullable
    private final String column;
    @Nullable
    private final String value;
    @Nullable
    private final Integer position;

    private InvalidNullByteException(@Nullable String source, @Nullable Integer rowNumber, @Nullable String column, @Nullable String value, @Nullable Integer position) {
        super(StringUtils.format("Encountered null byte at source[%s], rowNumber[%d], column[%s], value[%s], position[%s]", source, rowNumber, column, value, position));
        this.source = source;
        this.rowNumber = rowNumber;
        this.column = column;
        this.value = value;
        this.position = position;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InvalidNullByteException invalidNullByteException) {
        return new Builder(invalidNullByteException);
    }

    @Nullable
    public Integer getRowNumber() {
        return this.rowNumber;
    }

    @Nullable
    public String getColumn() {
        return this.column;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    @Nullable
    public Integer getPosition() {
        return this.position;
    }

    public static class Builder {
        @Nullable
        private String source;
        @Nullable
        private Integer rowNumber;
        @Nullable
        private String column;
        @Nullable
        private String value;
        @Nullable
        private Integer position;

        public Builder() {
        }

        public Builder(InvalidNullByteException invalidNullByteException) {
            this.source = invalidNullByteException.source;
            this.rowNumber = invalidNullByteException.rowNumber;
            this.column = invalidNullByteException.column;
            this.value = invalidNullByteException.value;
            this.position = invalidNullByteException.position;
        }

        public InvalidNullByteException build() {
            return new InvalidNullByteException(this.source, this.rowNumber, this.column, this.value, this.position);
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder rowNumber(Integer rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder column(String column) {
            this.column = column;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder position(Integer position) {
            this.position = position;
            return this;
        }
    }
}

