/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NestedDataDimensionHandler;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataJsonSerializer;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;

public class NestedDataModule
implements DruidModule {
    @Override
    public List<? extends Module> getJacksonModules() {
        return NestedDataModule.getJacksonModulesList();
    }

    public void configure(Binder binder) {
        NestedDataModule.registerHandlersAndSerde();
    }

    @VisibleForTesting
    public static void registerHandlersAndSerde() {
        if (ComplexMetrics.getSerdeForType("json") == null) {
            ComplexMetrics.registerSerde("json", NestedDataComplexTypeSerde.INSTANCE);
        }
        DimensionHandlerUtils.registerDimensionHandlerProvider("json", NestedDataDimensionHandler::new);
    }

    public static List<SimpleModule> getJacksonModulesList() {
        return Collections.singletonList(new SimpleModule("NestedDataModule").registerSubtypes(new NamedType[]{new NamedType(NestedFieldVirtualColumn.class, "nested-field")}).addSerializer(StructuredData.class, (JsonSerializer)new StructuredDataJsonSerializer()));
    }
}

