/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.utils.CollectionUtils;

public class JSONPathFieldSpec {
    private final JSONPathFieldType type;
    private final String name;
    private final String expr;
    private final List<String> nodes;

    @JsonCreator
    public JSONPathFieldSpec(@JsonProperty(value="type") JSONPathFieldType type, @JsonProperty(value="name") String name, @JsonProperty(value="expr") String expr, @JsonProperty(value="nodes") List<String> nodes) {
        this.type = type;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Missing 'name' in field spec");
        switch (type) {
            case ROOT: {
                this.expr = expr == null ? name : expr;
                this.nodes = null;
                break;
            }
            case TREE: {
                this.expr = null;
                Preconditions.checkArgument((!CollectionUtils.isNullOrEmpty(nodes) ? 1 : 0) != 0, (String)"Missing 'nodes' for field[%s], was [%s]", (Object[])new Object[]{name, nodes});
                this.nodes = nodes;
                break;
            }
            default: {
                this.expr = (String)Preconditions.checkNotNull((Object)expr, (String)"Missing 'expr' for field[%s]", (Object[])new Object[]{name});
                this.nodes = null;
            }
        }
    }

    public JSONPathFieldSpec(JSONPathFieldType type, String name, String expr) {
        this(type, name, expr, null);
    }

    @JsonProperty
    public JSONPathFieldType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getExpr() {
        return this.expr;
    }

    @JsonProperty
    public List<String> getNodes() {
        return this.nodes;
    }

    @JsonCreator
    public static JSONPathFieldSpec fromString(String name) {
        return JSONPathFieldSpec.createRootField(name);
    }

    public static JSONPathFieldSpec createNestedField(String name, String expr) {
        return new JSONPathFieldSpec(JSONPathFieldType.PATH, name, expr);
    }

    public static JSONPathFieldSpec createJqField(String name, String expr) {
        return new JSONPathFieldSpec(JSONPathFieldType.JQ, name, expr);
    }

    public static JSONPathFieldSpec createRootField(String name) {
        return new JSONPathFieldSpec(JSONPathFieldType.ROOT, name, null);
    }

    public static JSONPathFieldSpec createTreeField(String name, List<String> nodes) {
        return new JSONPathFieldSpec(JSONPathFieldType.TREE, name, null, nodes);
    }

    public static String getCompilePath(String expr) {
        return JsonPath.compile((String)expr, (Predicate[])new Predicate[0]).getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONPathFieldSpec that = (JSONPathFieldSpec)o;
        return this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.expr, that.expr) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.expr, this.nodes});
    }

    public String toString() {
        return "JSONPathFieldSpec{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", expr='" + this.expr + '\'' + ", nodes='" + this.nodes + '\'' + '}';
    }
}

