/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import org.apache.druid.java.util.common.logger.Logger;

public class ProcFsReader {
    private final File procDir;
    private static final Logger LOG = new Logger(ProcFsReader.class);
    private static final String BOOT_ID_PATH = "sys/kernel/random/boot_id";
    private static final String CPUINFO_PATH = "cpuinfo";

    public ProcFsReader(Path procFsRoot) {
        this.procDir = ((Path)Preconditions.checkNotNull((Object)procFsRoot, (Object)"procFsRoot")).toFile();
        Preconditions.checkArgument((boolean)this.procDir.isDirectory(), (String)"Not a directory: [%s]", (Object[])new Object[]{procFsRoot});
    }

    public UUID getBootId() {
        Path path = Paths.get(this.procDir.toString(), BOOT_ID_PATH);
        try {
            List<String> lines = Files.readAllLines(path);
            return lines.stream().map(UUID::fromString).findFirst().orElse(new UUID(0L, 0L));
        }
        catch (IOException ex) {
            LOG.error(ex, "Unable to read %s", path);
            return new UUID(0L, 0L);
        }
    }

    public long getProcessorCount() {
        Path path = Paths.get(this.procDir.toString(), CPUINFO_PATH);
        try {
            List<String> lines = Files.readAllLines(path);
            return lines.stream().filter(l -> l.startsWith("processor")).count();
        }
        catch (IOException ex) {
            LOG.error(ex, "Unable to read %s", path);
            return -1L;
        }
    }
}

