/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;

class StringExpr
extends ConstantExpr<String> {
    StringExpr(@Nullable String value) {
        super(ExpressionType.STRING, NullHandling.emptyToNullIfNeeded(value));
    }

    public String toString() {
        return (String)this.value;
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.of((String)this.value);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.constant((String)this.value, inspector.getMaxVectorSize());
    }

    @Override
    public String stringify() {
        return this.value == null ? "null" : StringUtils.format("'%s'", StringEscapeUtils.escapeJavaScript((String)((String)this.value)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringExpr that = (StringExpr)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

