/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.UnaryExpr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;
import org.apache.druid.segment.column.Types;

class UnaryNotExpr
extends UnaryExpr {
    UnaryNotExpr(String op, Expr expr) {
        super(op, expr);
    }

    @Override
    UnaryExpr copy(Expr expr) {
        return new UnaryNotExpr(this.op, expr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (NullHandling.sqlCompatible() && ret.value() == null) {
            return ExprEval.of(null);
        }
        if (!ExpressionProcessing.useStrictBooleans()) {
            ExpressionType retType = ret.type().is(ExprType.DOUBLE) ? ExpressionType.DOUBLE : ExpressionType.LONG;
            return ExprEval.ofBoolean(!ret.asBoolean(), (ExprType)retType.getType());
        }
        return ExprEval.ofLongBoolean(!ret.asBoolean());
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            ExpressionType implicitCast = super.getOutputType(inspector);
            if (Types.is(implicitCast, ExprType.STRING)) {
                return ExpressionType.LONG;
            }
            return implicitCast;
        }
        return ExpressionType.LONG;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return this.expr.canVectorize(inspector);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.not(inspector, this.expr);
    }
}

